/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.metrics.MicrometerCollector;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

class MicrometerCollectorService
implements Service {
    private final Supplier<ModelControllerClientFactory> modelControllerClientFactory;
    private final Supplier<Executor> managementExecutor;
    private final Supplier<ProcessStateNotifier> processStateNotifier;
    private final Supplier<WildFlyRegistry> registrySupplier;
    private final Consumer<MicrometerCollector> metricCollectorConsumer;
    private LocalModelControllerClient modelControllerClient;

    static Supplier<MicrometerCollector> install(OperationContext context) {
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(MicrometerSubsystemDefinition.MICROMETER_COLLECTOR_RUNTIME_CAPABILITY);
        Supplier modelControllerClientFactory = serviceBuilder.requiresCapability("org.wildfly.management.model-controller-client-factory", ModelControllerClientFactory.class, new String[0]);
        Supplier managementExecutor = serviceBuilder.requiresCapability("org.wildfly.management.executor", Executor.class, new String[0]);
        Supplier processStateNotifier = serviceBuilder.requiresCapability("org.wildfly.management.process-state-notifier", ProcessStateNotifier.class, new String[0]);
        Supplier registrySupplier = serviceBuilder.requiresCapability(MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY.getName(), WildFlyRegistry.class, new String[0]);
        MicrometerCollectorSupplier collectorSupplier = new MicrometerCollectorSupplier(serviceBuilder.provides(new ServiceName[]{MicrometerSubsystemDefinition.MICROMETER_COLLECTOR}));
        MicrometerCollectorService service = new MicrometerCollectorService(modelControllerClientFactory, managementExecutor, processStateNotifier, registrySupplier, collectorSupplier);
        serviceBuilder.setInstance((Service)service).install();
        return collectorSupplier;
    }

    MicrometerCollectorService(Supplier<ModelControllerClientFactory> modelControllerClientFactory, Supplier<Executor> managementExecutor, Supplier<ProcessStateNotifier> processStateNotifier, Supplier<WildFlyRegistry> registrySupplier, Consumer<MicrometerCollector> metricCollectorConsumer) {
        this.modelControllerClientFactory = modelControllerClientFactory;
        this.managementExecutor = managementExecutor;
        this.processStateNotifier = processStateNotifier;
        this.registrySupplier = registrySupplier;
        this.metricCollectorConsumer = metricCollectorConsumer;
    }

    public void start(StartContext context) {
        this.modelControllerClient = this.modelControllerClientFactory.get().createClient(this.managementExecutor.get());
        MicrometerCollector micrometerCollector = new MicrometerCollector(this.modelControllerClient, this.processStateNotifier.get(), this.registrySupplier.get());
        this.metricCollectorConsumer.accept(micrometerCollector);
    }

    public void stop(StopContext context) {
        this.metricCollectorConsumer.accept(null);
        this.modelControllerClient.close();
    }

    private static final class MicrometerCollectorSupplier
    implements Consumer<MicrometerCollector>,
    Supplier<MicrometerCollector> {
        private final Consumer<MicrometerCollector> wrapped;
        private volatile MicrometerCollector collector;

        private MicrometerCollectorSupplier(Consumer<MicrometerCollector> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void accept(MicrometerCollector micrometerCollector) {
            this.collector = micrometerCollector;
            this.wrapped.accept(micrometerCollector);
        }

        @Override
        public MicrometerCollector get() {
            return this.collector;
        }
    }
}

