/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator;

import org.hibernate.Incubating;
import org.hibernate.dialect.Dialect;
import org.hibernate.generator.Generator;
import org.hibernate.generator.internal.NaturalIdHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.id.insert.InsertReturningDelegate;
import org.hibernate.id.insert.UniqueKeySelectingDelegate;
import org.hibernate.persister.entity.EntityPersister;

public interface OnExecutionGenerator
extends Generator {
    public boolean referenceColumnsInSql(Dialect var1);

    public boolean writePropertyValue();

    public String[] getReferencedColumnValues(Dialect var1);

    @Incubating
    default public InsertGeneratedIdentifierDelegate getGeneratedIdentifierDelegate(PostInsertIdentityPersister persister) {
        Dialect dialect = persister.getFactory().getJdbcServices().getDialect();
        if (dialect.supportsInsertReturningGeneratedKeys()) {
            return new GetGeneratedKeysDelegate(persister, dialect, false);
        }
        if (dialect.supportsInsertReturning()) {
            return new InsertReturningDelegate(persister, dialect);
        }
        return new UniqueKeySelectingDelegate(persister, dialect, this.getUniqueKeyPropertyNames(persister));
    }

    @Incubating
    default public String[] getUniqueKeyPropertyNames(EntityPersister persister) {
        return NaturalIdHelper.getNaturalIdPropertyNames(persister);
    }

    @Override
    default public boolean generatedOnExecution() {
        return true;
    }
}

