/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractReturningDelegate;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertSelectIdentityInsert;
import org.hibernate.id.insert.TableInsertReturningBuilder;
import org.hibernate.jdbc.Expectation;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;

public class InsertReturningDelegate
extends AbstractReturningDelegate {
    private final PostInsertIdentityPersister persister;
    private final Dialect dialect;

    public InsertReturningDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
        super(persister);
        this.persister = persister;
        this.dialect = dialect;
    }

    @Override
    @Deprecated
    public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert(SqlStringGenerationContext context) {
        InsertSelectIdentityInsert insert = new InsertSelectIdentityInsert(this.persister.getFactory());
        insert.addGeneratedColumns(this.persister.getRootTableKeyColumnNames(), (OnExecutionGenerator)this.persister.getGenerator());
        return insert;
    }

    @Override
    public TableInsertBuilder createTableInsertBuilder(BasicEntityIdentifierMapping identifierMapping, Expectation expectation, SessionFactoryImplementor sessionFactory) {
        return new TableInsertReturningBuilder(this.persister, sessionFactory);
    }

    @Override
    protected Object executeAndExtract(String insertSql, PreparedStatement insertStatement, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        JdbcServices jdbcServices = session.getJdbcServices();
        ResultSet resultSet = jdbcCoordinator.getResultSetReturn().execute(insertStatement, insertSql);
        try {
            Object object = IdentifierGeneratorHelper.getGeneratedIdentity(this.persister.getNavigableRole().getFullPath(), resultSet, this.persister, session);
            return object;
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to extract generated key(s) from generated-keys ResultSet", insertSql);
        }
        finally {
            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(resultSet, insertStatement);
        }
    }

    @Override
    public String prepareIdentifierGeneratingInsert(String insertSQL) {
        return this.dialect.getIdentityColumnSupport().appendIdentitySelectToInsert(insertSQL);
    }

    @Override
    public PreparedStatement prepareStatement(String insertSql, SharedSessionContractImplementor session) {
        return session.getJdbcCoordinator().getMutationStatementPreparer().prepareStatement(insertSql, 2);
    }
}

