/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.Ownership;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.IracUtils;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.LogSupplier;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.spi.SiteEntry;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;

public class NonTxIracRemoteSiteInterceptor
extends DDAsyncInterceptor
implements LogSupplier {
    private static final Log log = LogFactory.getLog(NonTxIracRemoteSiteInterceptor.class);
    private final boolean needsVersions;
    private final InvocationSuccessAction<DataWriteCommand> setMetadataForOwnerAction = this::setIracMetadataForOwner;
    @Inject
    XSiteEntryMergePolicy<Object, Object> mergePolicy;
    @Inject
    IracVersionGenerator iracVersionGenerator;
    @Inject
    IracTombstoneManager iracTombstoneManager;
    @Inject
    VersionGenerator versionGenerator;
    @Inject
    ClusteringDependentLogic clusteringDependentLogic;
    @Inject
    IracManager iracManager;

    public NonTxIracRemoteSiteInterceptor(boolean needsVersions) {
        this.needsVersions = needsVersions;
    }

    private static SiteEntry<Object> createSiteEntryFrom(CacheEntry<?, ?> entry, String siteName) {
        assert (entry instanceof MVCCEntry);
        MVCCEntry mvccEntry = (MVCCEntry)entry;
        return new SiteEntry<Object>(siteName, mvccEntry.getOldValue(), mvccEntry.getOldMetadata());
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        Ownership ownership = this.getOwnership(command.getSegment());
        switch (ownership) {
            case PRIMARY: {
                CompletionStage<Boolean> validationResult = this.validateOnPrimary(ctx, command);
                if (CompletionStages.isCompletedSuccessfully(validationResult)) {
                    return this.validate(validationResult.toCompletableFuture().join(), ctx, command);
                }
                return validationResult.thenApply(isValid -> this.validate((boolean)isValid, ctx, command));
            }
            case BACKUP: {
                if (ctx.isOriginLocal()) break;
                return this.invokeNextThenAccept(ctx, command, this.setMetadataForOwnerAction);
            }
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public boolean isTraceEnabled() {
        return log.isTraceEnabled();
    }

    @Override
    public Log getLog() {
        return log;
    }

    private Object validate(boolean isValid, InvocationContext ctx, DataWriteCommand command) {
        return isValid ? this.invokeNextThenAccept(ctx, command, this.setMetadataForOwnerAction) : null;
    }

    private CompletionStage<Boolean> validateOnPrimary(InvocationContext ctx, IracPutKeyValueCommand command) {
        Object key = command.getKey();
        CacheEntry entry = ctx.lookupEntry(key);
        IracMetadata localMetadata = this.getIracMetadata(entry);
        if (localMetadata == null) {
            localMetadata = this.iracTombstoneManager.getTombstone(key);
        }
        if (this.needsVersions) {
            PrivateMetadata metadata = PrivateMetadata.getBuilder(command.getInternalMetadata()).entryVersion(this.generateWriteSkewVersion(entry)).build();
            command.setInternalMetadata(key, metadata);
        }
        if (localMetadata != null) {
            return this.validateRemoteUpdate(entry, command, localMetadata);
        }
        return CompletableFutures.completedTrue();
    }

    private void setIracMetadataForOwner(InvocationContext ctx, DataWriteCommand command, Object rv) {
        Object key = command.getKey();
        PrivateMetadata metadata = command.getInternalMetadata();
        this.iracVersionGenerator.updateVersion(command.getSegment(), metadata.iracMetadata().getVersion());
        IracUtils.setPrivateMetadata(ctx.lookupEntry(key), command.getSegment(), metadata, this.iracTombstoneManager, this);
    }

    private CompletionStage<Boolean> validateRemoteUpdate(CacheEntry<?, ?> entry, IracPutKeyValueCommand command, IracMetadata localMetadata) {
        IracMetadata remoteMetadata = command.getInternalMetadata().iracMetadata();
        assert (remoteMetadata != null);
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] Comparing local and remote metadata: %s and %s", localMetadata, remoteMetadata);
        }
        IracEntryVersion localVersion = localMetadata.getVersion();
        IracEntryVersion remoteVersion = remoteMetadata.getVersion();
        if (command.isExpiration()) {
            switch (remoteVersion.compareTo(localVersion)) {
                case AFTER: 
                case EQUAL: {
                    return CompletableFutures.completedTrue();
                }
            }
            this.iracManager.incrementNumberOfDiscards();
            this.discardUpdate(entry, command, remoteMetadata);
            return CompletableFutures.completedFalse();
        }
        switch (remoteVersion.compareTo(localVersion)) {
            case CONFLICTING: {
                return this.resolveConflict(entry, command, localMetadata, remoteMetadata);
            }
            case EQUAL: 
            case BEFORE: {
                this.iracManager.incrementNumberOfDiscards();
                this.discardUpdate(entry, command, remoteMetadata);
                return CompletableFutures.completedFalse();
            }
        }
        return CompletableFutures.completedTrue();
    }

    private CompletionStage<Boolean> resolveConflict(CacheEntry<?, ?> entry, IracPutKeyValueCommand command, IracMetadata localMetadata, IracMetadata remoteMetadata) {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] Conflict found between local and remote metadata: %s and %s", localMetadata, remoteMetadata);
        }
        SiteEntry<Object> localSiteEntry = NonTxIracRemoteSiteInterceptor.createSiteEntryFrom(entry, localMetadata.getSite());
        SiteEntry<Object> remoteSiteEntry = command.createSiteEntry(remoteMetadata.getSite());
        return this.mergePolicy.merge(entry.getKey(), localSiteEntry, remoteSiteEntry).thenApply(resolved -> {
            if (log.isTraceEnabled()) {
                log.tracef("[IRAC] resolve(%s, %s) = %s", localSiteEntry, remoteSiteEntry, resolved);
            }
            if (resolved.equals(localSiteEntry)) {
                this.discardUpdate(entry, command, remoteMetadata);
                this.iracManager.incrementNumberOfConflictLocalWins();
                return false;
            }
            if (!resolved.equals(remoteSiteEntry)) {
                Object key = entry.getKey();
                command.updateCommand((SiteEntry<Object>)resolved);
                PrivateMetadata.Builder builder = PrivateMetadata.getBuilder(command.getInternalMetadata()).iracMetadata(this.mergeVersion(resolved.getSiteName(), localMetadata.getVersion(), remoteMetadata.getVersion()));
                command.setInternalMetadata(key, builder.build());
                this.iracManager.incrementNumberOfConflictMerged();
            } else {
                this.iracManager.incrementNumberOfConflictRemoteWins();
            }
            return true;
        });
    }

    private IracMetadata mergeVersion(String siteName, IracEntryVersion localVersion, IracEntryVersion remoteVersion) {
        return new IracMetadata(siteName, localVersion.merge(remoteVersion));
    }

    private IncrementableEntryVersion generateWriteSkewVersion(CacheEntry<?, ?> entry) {
        IncrementableEntryVersion version = WriteSkewHelper.incrementVersion(entry, this.versionGenerator);
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] Generated Write Skew version for %s=%s", entry.getKey(), version);
        }
        return version;
    }

    private void discardUpdate(CacheEntry<?, ?> entry, DataWriteCommand command, IracMetadata metadata) {
        Object key = entry.getKey();
        IracUtils.logUpdateDiscarded(key, metadata, this);
        assert (metadata != null) : "[IRAC] Metadata must not be null!";
        command.fail();
        entry.setChanged(false);
        this.iracVersionGenerator.updateVersion(command.getSegment(), metadata.getVersion());
    }

    private IracMetadata getIracMetadata(CacheEntry<?, ?> entry) {
        PrivateMetadata privateMetadata = entry.getInternalMetadata();
        if (privateMetadata == null) {
            return this.iracTombstoneManager.getTombstone(entry.getKey());
        }
        IracMetadata metadata = privateMetadata.iracMetadata();
        return metadata == null ? this.iracTombstoneManager.getTombstone(entry.getKey()) : metadata;
    }

    private Ownership getOwnership(int segment) {
        return this.clusteringDependentLogic.getCacheTopology().getSegmentDistribution(segment).writeOwnership();
    }
}

