/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.util.Map;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexCompositeNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeCollector;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexFieldTemplate;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexCompositeNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexField;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTemplateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.pattern.spi.SimpleGlobPattern;
import org.hibernate.search.util.common.reporting.EventContext;

abstract class AbstractLuceneIndexFieldTemplateBuilder<S extends AbstractLuceneIndexFieldTemplateBuilder<S, T>, T extends AbstractLuceneIndexFieldTemplate<?>>
implements IndexSchemaFieldTemplateOptionsStep<S>,
LuceneIndexNodeContributor,
IndexSchemaBuildContext {
    private final AbstractLuceneIndexCompositeNodeBuilder parent;
    protected final String absolutePath;
    protected final IndexFieldInclusion inclusion;
    private final String prefix;
    private SimpleGlobPattern relativePathGlob;
    private boolean multiValued = false;

    AbstractLuceneIndexFieldTemplateBuilder(AbstractLuceneIndexCompositeNodeBuilder parent, String templateName, IndexFieldInclusion inclusion, String prefix) {
        this.parent = parent;
        this.absolutePath = FieldPaths.compose((String)parent.getAbsolutePath(), (String)templateName);
        this.inclusion = inclusion;
        this.prefix = prefix;
    }

    public EventContext eventContext() {
        return this.parent.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.parent.getAbsolutePath())).append(EventContexts.fromFieldTemplateAbsolutePath((String)this.absolutePath));
    }

    public S matchingPathGlob(String pathGlob) {
        this.relativePathGlob = SimpleGlobPattern.compile((String)pathGlob);
        return this.thisAsS();
    }

    public S multiValued() {
        this.multiValued = true;
        return this.thisAsS();
    }

    @Override
    public void contribute(LuceneIndexNodeCollector collector, LuceneIndexCompositeNode parentNode, Map<String, LuceneIndexField> staticChildrenByNameForParent) {
        SimpleGlobPattern absolutePathGlob = FieldPaths.absolutize((String)this.parent.getAbsolutePath(), (String)this.prefix, (SimpleGlobPattern)(this.relativePathGlob != null ? this.relativePathGlob : SimpleGlobPattern.compile((String)"*")));
        this.doContribute(collector, parentNode, absolutePathGlob, this.multiValued);
    }

    protected abstract S thisAsS();

    protected abstract void doContribute(LuceneIndexNodeCollector var1, LuceneIndexCompositeNode var2, SimpleGlobPattern var3, boolean var4);
}

