/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.distribution.CacheKeyDistribution;
import org.wildfly.clustering.infinispan.distribution.KeyDistribution;
import org.wildfly.clustering.server.NodeFactory;

public class PrimaryOwnerLocator<K>
implements Function<K, Node> {
    private final KeyDistribution distribution;
    private final NodeFactory<Address> memberFactory;

    public PrimaryOwnerLocator(Cache<? extends K, ?> cache, NodeFactory<Address> memberFactory) {
        this((KeyDistribution)new CacheKeyDistribution(cache), memberFactory);
    }

    PrimaryOwnerLocator(KeyDistribution distribution, NodeFactory<Address> memberFactory) {
        this.distribution = distribution;
        this.memberFactory = memberFactory;
    }

    @Override
    public Node apply(K key) {
        Node member = null;
        while (member == null) {
            Address address = this.distribution.getPrimaryOwner(key);
            member = this.memberFactory.createNode((Object)address);
        }
        return member;
    }
}

