/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.util.regex.Pattern;
import org.jboss.weld.util.AnnotatedTypes;

class WeldVetoExtension
implements Extension {
    private Pattern vetoAnnotatedTypePattern;

    WeldVetoExtension(String regex) {
        this.vetoAnnotatedTypePattern = Pattern.compile(regex);
    }

    void processAnnotatedType(@Observes ProcessAnnotatedType<?> event) {
        if (this.vetoAnnotatedTypePattern.matcher(event.getAnnotatedType().getJavaClass().getName()).matches() && !AnnotatedTypes.hasBeanDefiningAnnotation(event.getAnnotatedType())) {
            event.veto();
        }
    }

    void cleanupAfterBoot(@Observes AfterDeploymentValidation event) {
        this.vetoAnnotatedTypePattern = null;
    }
}

