/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.InstMgrOperationStepHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public class InstMgrCreateSnapshotHandler
extends InstMgrOperationStepHandler {
    public static final String OPERATION_NAME = "clone-export";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("clone-export", InstMgrResolver.RESOLVER).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY}).setRuntimeOnly().setReplyType(ModelType.STRING).build();

    public InstMgrCreateSnapshotHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.acquireControllerLock();
                try {
                    Path serverHome = InstMgrCreateSnapshotHandler.this.imService.getHomeDir();
                    Path temporalDir = InstMgrCreateSnapshotHandler.this.imService.getControllerTempDir();
                    MavenOptions mavenOptions = new MavenOptions(null, false);
                    InstallationManager im = InstMgrCreateSnapshotHandler.this.imf.create(serverHome, mavenOptions);
                    Path exportFile = temporalDir.resolve("installer-clone-export" + UUID.randomUUID() + ".zip");
                    Path snapshot = im.createSnapshot(exportFile);
                    String uuid = context.attachResultStream("application/zip", Files.newInputStream(snapshot, StandardOpenOption.DELETE_ON_CLOSE));
                    context.getResult().set(uuid);
                }
                catch (IllegalArgumentException e) {
                    throw new OperationFailedException((Throwable)e);
                }
                catch (RuntimeException | OperationFailedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

