/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.instmgr.InstMgrHistoryHandler;
import org.wildfly.core.instmgr.InstMgrHistoryRevisionHandler;
import org.wildfly.core.instmgr.cli.AbstractInstMgrCommand;
import org.wildfly.core.instmgr.cli.InstMgrActivator;
import org.wildfly.installationmanager.ArtifactChange;
import org.wildfly.installationmanager.ChannelChange;

@CommandDefinition(name="history", description="List previous installation states.", activator=InstMgrActivator.class)
public class HistoryCommand
extends AbstractInstMgrCommand {
    @Option(name="revision")
    private String revision;

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        block15: {
            ModelNode result;
            CommandContext ctx;
            block14: {
                String channelName;
                ctx = commandInvocation.getCommandContext();
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    ctx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
                    return CommandResult.FAILURE;
                }
                ModelNode response = this.executeOp(ctx, this.host);
                result = response.get("result");
                if (this.revision == null) break block14;
                List artifactChanges = result.get("artifact-changes").asListOrEmpty();
                List channelChanges = result.get("channel-changes").asListOrEmpty();
                if (!artifactChanges.isEmpty()) {
                    ctx.printLine("Artifact Updates:");
                    int maxLength = 0;
                    for (ModelNode artifactChange : artifactChanges) {
                        channelName = artifactChange.get("name").asString();
                        maxLength = maxLength < channelName.length() ? channelName.length() : maxLength;
                    }
                    maxLength += 2;
                    for (ModelNode artifactChange : artifactChanges) {
                        String status = artifactChange.get("status").asString();
                        String channelName2 = artifactChange.get("name").asString();
                        String oldVersion = artifactChange.get("old-version").asStringOrNull();
                        String newVersion = artifactChange.get("new-version").asStringOrNull();
                        if (status.equals(ArtifactChange.Status.UPDATED.name().toLowerCase())) {
                            ctx.printLine(String.format(" %1$-" + maxLength + "s %2$15s ==> %3$-15s", channelName2, oldVersion, newVersion));
                            continue;
                        }
                        if (status.equals(ArtifactChange.Status.REMOVED.name().toLowerCase())) {
                            ctx.printLine(String.format(" %1$-" + maxLength + "s %2$15s ==> []", channelName2, oldVersion));
                            continue;
                        }
                        if (!status.equals(ArtifactChange.Status.INSTALLED.name().toLowerCase())) continue;
                        ctx.printLine(String.format(" %1$-" + maxLength + "s [] ==> %2$-15s", channelName2, newVersion));
                    }
                    ctx.printLine("");
                }
                if (channelChanges.isEmpty()) break block15;
                ctx.printLine("Configuration changes:");
                for (ModelNode channelChange : channelChanges) {
                    String status = channelChange.get("status").asString();
                    channelName = channelChange.get("channel-name").asString();
                    if (status.equals(ChannelChange.Status.MODIFIED.name().toLowerCase())) {
                        ctx.printLine(String.format("[Updated channel] %s", channelName));
                    } else if (status.equals(ChannelChange.Status.REMOVED.name().toLowerCase())) {
                        ctx.printLine(String.format("[Removed channel] %s", channelName));
                    } else if (status.equals(ChannelChange.Status.ADDED.name().toLowerCase())) {
                        ctx.printLine(String.format("[Added channel] %s", channelName));
                    }
                    String oldManifest = channelChange.get(new String[]{"manifest", "old-manifest"}).asStringOrNull();
                    String newManifest = channelChange.get(new String[]{"manifest", "new-manifest"}).asStringOrNull();
                    oldManifest = oldManifest == null ? "[]" : oldManifest;
                    newManifest = newManifest == null ? "[]" : newManifest;
                    ctx.printLine(String.format("\tManifest:\t%s ==> %s", oldManifest, newManifest));
                    ctx.printLine("\tRepositories:");
                    List repositories = channelChange.get("repositories").asList();
                    for (ModelNode repository : repositories) {
                        String oldRepo = repository.get("old-repository").asStringOrNull();
                        String newRepo = repository.get("new-repository").asStringOrNull();
                        oldRepo = oldRepo == null ? "[]" : oldRepo;
                        newRepo = newRepo == null ? "[]" : newRepo;
                        ctx.printLine(String.format("\t\t%s ==> %s", oldRepo, newRepo));
                    }
                }
                break block15;
            }
            List results = result.asListOrEmpty();
            for (ModelNode resultMn : results) {
                String hash = resultMn.get("hash").asString();
                String timeStamp = resultMn.get("timestamp").asString();
                String type = resultMn.get("type").asString();
                String description = resultMn.get("description").asStringOrNull();
                description = description == null ? "[]" : description;
                ctx.printLine(String.format("[%s] %s - %s %s", hash, timeStamp, type, description));
            }
        }
        return CommandResult.SUCCESS;
    }

    @Override
    protected Operation buildOperation() {
        ModelNode op = new ModelNode();
        if (this.revision != null) {
            op.get("operation").set(InstMgrHistoryRevisionHandler.DEFINITION.getName());
            op.get("revision").set(this.revision);
        } else {
            op.get("operation").set(InstMgrHistoryHandler.DEFINITION.getName());
        }
        return OperationBuilder.create((ModelNode)op).build();
    }
}

