/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.infinispan.commons.util.CloseableIterator;

public class LazyConcatIterator<E>
implements CloseableIterator<E> {
    private final CloseableIterator<E> iterator1;
    private final Supplier<? extends CloseableIterator<E>> supplier;
    private CloseableIterator<E> iterator2;

    public LazyConcatIterator(CloseableIterator<E> first, Supplier<? extends CloseableIterator<E>> supplier) {
        this.iterator1 = Objects.requireNonNull(first);
        this.supplier = Objects.requireNonNull(supplier);
    }

    public void close() {
        try (CloseableIterator<E> closeme = this.iterator1;){
            if (this.iterator2 != null) {
                this.iterator2.close();
            }
        }
    }

    public boolean hasNext() {
        if (this.iterator2 == null) {
            boolean hasNext = this.iterator1.hasNext();
            if (hasNext) {
                return true;
            }
            this.iterator2 = this.supplier.get();
        }
        return this.iterator2.hasNext();
    }

    public E next() {
        if (this.iterator2 == null) {
            if (this.iterator1.hasNext()) {
                return (E)this.iterator1.next();
            }
            this.iterator2 = this.supplier.get();
        }
        if (this.iterator2.hasNext()) {
            return (E)this.iterator2.next();
        }
        throw new NoSuchElementException();
    }
}

