/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.distribution.BiasedCollector;
import org.infinispan.interceptors.distribution.Collector;
import org.infinispan.interceptors.distribution.PrimaryOwnerOnlyCollector;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class CommandAckCollector {
    private static final Log log = LogFactory.getLog(CommandAckCollector.class);
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    ScheduledExecutorService timeoutExecutor;
    @Inject
    Configuration configuration;
    private final ConcurrentHashMap<Long, BaseAckTarget> collectorMap = new ConcurrentHashMap();
    private long timeoutNanoSeconds;
    private Collection<Address> currentMembers;

    @Start
    public void start() {
        this.timeoutNanoSeconds = TimeUnit.MILLISECONDS.toNanos(this.configuration.clustering().remoteTimeout());
        this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).addListener((a, ignored) -> {
            this.timeoutNanoSeconds = TimeUnit.MILLISECONDS.toNanos((Long)a.get());
        });
    }

    public <T> Collector<T> create(long id, Collection<Address> backupOwners, int topologyId) {
        if (backupOwners.isEmpty()) {
            return new PrimaryOwnerOnlyCollector();
        }
        SingleKeyCollector collector = new SingleKeyCollector(id, backupOwners, topologyId);
        BaseAckTarget prev = this.collectorMap.put(id, collector);
        assert (prev == null || prev.topologyId < topologyId) : String.format("replaced old collector '%s' by '%s'", prev, collector);
        if (log.isTraceEnabled()) {
            log.tracef("Created new collector for %s. BackupOwners=%s", id, backupOwners);
        }
        return collector;
    }

    public BiasedCollector createBiased(long id, int topologyId) {
        BiasedKeyCollector collector = new BiasedKeyCollector(id, topologyId);
        BaseAckTarget prev = this.collectorMap.put(id, collector);
        assert (prev == null || prev.topologyId < topologyId) : prev.toString();
        if (log.isTraceEnabled()) {
            log.tracef("Created new biased collector for %d", id);
        }
        return collector;
    }

    public MultiTargetCollector createMultiTargetCollector(long id, int primaries, int topologyId) {
        MultiTargetCollectorImpl multiTargetCollector = new MultiTargetCollectorImpl(id, primaries, topologyId);
        BaseAckTarget prev = this.collectorMap.put(id, multiTargetCollector);
        assert (prev == null || prev.topologyId < topologyId) : prev.toString();
        if (log.isTraceEnabled()) {
            log.tracef("Created new multi target collector for %d", id);
        }
        return multiTargetCollector;
    }

    public <T> Collector<T> createSegmentBasedCollector(long id, Map<Address, Collection<Integer>> backups, int topologyId) {
        if (backups.isEmpty()) {
            return new PrimaryOwnerOnlyCollector();
        }
        SegmentBasedCollector collector = new SegmentBasedCollector(id, backups, topologyId);
        BaseAckTarget prev = this.collectorMap.put(id, collector);
        assert (prev == null || prev.topologyId < topologyId) : String.format("replaced old collector '%s' by '%s'", prev, collector);
        if (log.isTraceEnabled()) {
            log.tracef("Created new collector for %s. BackupSegments=%s", id, backups);
        }
        return collector;
    }

    public void multiKeyBackupAck(long id, Address from, int segment, int topologyId) {
        SegmentBasedCollector collector = (SegmentBasedCollector)this.collectorMap.get(id);
        if (collector != null) {
            collector.backupAck(from, segment, topologyId);
        }
    }

    public void backupAck(long id, Address from, int topologyId) {
        BaseAckTarget ackTarget = this.collectorMap.get(id);
        if (ackTarget instanceof SingleKeyCollector) {
            ((SingleKeyCollector)ackTarget).backupAck(topologyId, from);
        } else if (ackTarget instanceof MultiTargetCollectorImpl) {
            ((MultiTargetCollectorImpl)ackTarget).backupAck(topologyId, from);
        }
    }

    public void completeExceptionally(long id, Throwable throwable, int topologyId) {
        BaseAckTarget ackTarget = this.collectorMap.get(id);
        if (ackTarget != null) {
            ackTarget.completeExceptionally(throwable, topologyId);
        }
    }

    public List<Long> getPendingCommands() {
        return new ArrayList<Long>(this.collectorMap.keySet());
    }

    public boolean hasPendingBackupAcks(long id) {
        BaseAckTarget ackTarget = this.collectorMap.get(id);
        return ackTarget != null && ackTarget.hasPendingBackupAcks();
    }

    public void onMembersChange(Collection<Address> members) {
        HashSet<Address> currentMembers = new HashSet<Address>(members);
        this.currentMembers = currentMembers;
        for (BaseAckTarget ackTarget : this.collectorMap.values()) {
            ackTarget.onMembersChange(currentMembers);
        }
    }

    private TimeoutException createTimeoutException(String address, long id) {
        return log.timeoutWaitingForAcks(Util.prettyPrintTime((long)this.timeoutNanoSeconds, (TimeUnit)TimeUnit.NANOSECONDS), address, id);
    }

    private class SingleKeyCollector<T>
    extends BaseCollector<T> {
        final Collection<Address> backupOwners;

        private SingleKeyCollector(long id, Collection<Address> backupOwners, int topologyId) {
            super(id, topologyId);
            this.backupOwners = new HashSet<Address>(backupOwners);
        }

        @Override
        synchronized boolean hasPendingBackupAcks() {
            if (log.isTraceEnabled()) {
                log.tracef("Pending backup acks: %s", this.backupOwners);
            }
            return !this.backupOwners.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onMembersChange(Collection<Address> members) {
            boolean empty;
            SingleKeyCollector singleKeyCollector = this;
            synchronized (singleKeyCollector) {
                empty = this.backupOwners.retainAll(members) && this.backupOwners.isEmpty();
            }
            if (empty && this.primaryResultReceived) {
                if (log.isTraceEnabled()) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.markReady();
            }
        }

        @Override
        public void primaryResult(T result, boolean success) {
            this.primaryResult = result;
            this.primaryResultReceived = true;
            if (!success || !this.hasPendingBackupAcks()) {
                this.markReady();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void backupAck(int topologyId, Address from) {
            boolean empty;
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] Backup ACK. Address=%s, TopologyId=%s (expected=%s)", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            SingleKeyCollector singleKeyCollector = this;
            synchronized (singleKeyCollector) {
                empty = this.backupOwners.remove(from) && this.backupOwners.isEmpty();
            }
            if (empty && this.primaryResultReceived) {
                this.markReady();
            }
        }

        void markReady() {
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] Ready!", this.id);
            }
            this.future.complete(this.primaryResult);
        }

        @Override
        protected synchronized String getAddress() {
            return this.backupOwners.toString();
        }
    }

    private abstract class BaseAckTarget<T>
    implements Callable<Void>,
    BiConsumer<T, Throwable> {
        final long id;
        final int topologyId;
        final ScheduledFuture<?> timeoutTask;

        private BaseAckTarget(long id, int topologyId) {
            this.topologyId = topologyId;
            this.id = id;
            this.timeoutTask = CommandAckCollector.this.timeoutExecutor.schedule(this, CommandAckCollector.this.timeoutNanoSeconds, TimeUnit.NANOSECONDS);
        }

        @Override
        public final void accept(T t, Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] Collector completed with ret=%s, throw=%s", this.id, t, throwable);
            }
            boolean removed = CommandAckCollector.this.collectorMap.remove(this.id, this);
            assert (removed);
            this.timeoutTask.cancel(false);
        }

        abstract void completeExceptionally(Throwable var1, int var2);

        abstract boolean hasPendingBackupAcks();

        abstract void onMembersChange(Collection<Address> var1);
    }

    private class BiasedKeyCollector
    extends SingleKeyCollector<ValidResponse>
    implements BiasedCollector {
        private Collection<Address> unsolicitedAcks;

        private BiasedKeyCollector(long id, int topologyId) {
            super(id, Collections.emptyList(), topologyId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void backupAck(int topologyId, Address from) {
            boolean empty;
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] Backup ACK. Address=%s, TopologyId=%s (expected=%s)", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            BiasedKeyCollector biasedKeyCollector = this;
            synchronized (biasedKeyCollector) {
                if (!this.backupOwners.remove(from)) {
                    if (this.unsolicitedAcks == null) {
                        this.unsolicitedAcks = new ArrayList<Address>(4);
                    }
                    log.tracef("[Collector#%s] Unsolicited ACK", this.id);
                    this.unsolicitedAcks.add(from);
                }
                empty = this.backupOwners.isEmpty();
            }
            if (empty && this.primaryResultReceived) {
                this.markReady();
            }
        }

        @Override
        public synchronized void addPendingAcks(boolean success, Address[] waitFor) {
            if (success && waitFor != null) {
                Collection<Address> members = CommandAckCollector.this.currentMembers;
                for (Address address : waitFor) {
                    if (members != null && !members.contains(address)) continue;
                    this.backupOwners.add(address);
                }
            }
            if (this.unsolicitedAcks != null) {
                this.unsolicitedAcks.removeIf(this.backupOwners::remove);
            }
        }
    }

    private class MultiTargetCollectorImpl
    extends BaseAckTarget<Void>
    implements MultiTargetCollector {
        private final Map<Address, SingleTargetCollectorImpl> primaryCollectors;
        private final List<Address> pendingAcks;
        private final CompletableFuture<Void> acksFuture;
        private final int primaries;
        private List<Address> unsolicitedAcks;
        private Throwable throwable;

        MultiTargetCollectorImpl(long id, int primaries, int topologyId) {
            super(id, topologyId);
            this.primaryCollectors = new HashMap<Address, SingleTargetCollectorImpl>();
            this.pendingAcks = new ArrayList<Address>();
            this.acksFuture = new CompletableFuture();
            this.primaries = primaries;
            this.acksFuture.whenComplete((BiConsumer)this);
        }

        @Override
        public synchronized BiasedCollector collectorFor(Address target) {
            if (this.throwable != null) {
                throw CompletableFutures.asCompletionException((Throwable)this.throwable);
            }
            SingleTargetCollectorImpl collector = new SingleTargetCollectorImpl(this);
            Collector prev = this.primaryCollectors.put(target, collector);
            assert (prev == null) : prev.toString();
            return collector;
        }

        synchronized void addPendingAcks(Address[] waitFor) {
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] Adding pending acks from %s, existing are %s", this.id, Arrays.toString(waitFor), this.pendingAcks);
            }
            Collection<Address> members = CommandAckCollector.this.currentMembers;
            for (Address member : waitFor) {
                if (members != null && !members.contains(member)) continue;
                this.pendingAcks.add(member);
            }
            if (this.unsolicitedAcks != null) {
                this.unsolicitedAcks.removeIf(this.pendingAcks::remove);
            }
        }

        synchronized void backupAck(int topologyId, Address from) {
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] PutMap Backup ACK. Address=%s. TopologyId=%s (expected=%s).", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (topologyId == this.topologyId && !this.pendingAcks.remove(from)) {
                if (this.unsolicitedAcks == null) {
                    this.unsolicitedAcks = new ArrayList<Address>(4);
                }
                this.unsolicitedAcks.add(from);
            }
            this.checkComplete();
        }

        @Override
        synchronized void completeExceptionally(Throwable throwable, int topologyId) {
            if (topologyId == this.topologyId) {
                this.throwable = throwable;
                for (Collector collector : this.primaryCollectors.values()) {
                    collector.primaryException(throwable);
                }
            }
        }

        @Override
        synchronized boolean hasPendingBackupAcks() {
            return !this.pendingAcks.isEmpty();
        }

        @Override
        synchronized void onMembersChange(Collection<Address> members) {
            this.pendingAcks.retainAll(members);
            for (Map.Entry<Address, SingleTargetCollectorImpl> pair : this.primaryCollectors.entrySet()) {
                if (members.contains(pair.getKey())) continue;
                pair.getValue().primaryException((Throwable)((Object)OutdatedTopologyException.RETRY_NEXT_TOPOLOGY));
            }
        }

        @Override
        public Void call() {
            this.completeExceptionally((Throwable)((Object)CommandAckCollector.this.createTimeoutException(this.getPendingAcksString(), this.id)), this.topologyId);
            return null;
        }

        private synchronized String getPendingAcksString() {
            return this.pendingAcks.toString();
        }

        synchronized void checkComplete() {
            if (this.primaries != this.primaryCollectors.size()) {
                return;
            }
            for (SingleTargetCollectorImpl c : this.primaryCollectors.values()) {
                if (c.resultFuture.isDone()) continue;
                return;
            }
            if (!this.hasPendingBackupAcks()) {
                this.acksFuture.complete(null);
            }
        }
    }

    private class SegmentBasedCollector<T>
    extends BaseCollector<T> {
        @GuardedBy(value="this")
        private final Map<Address, Collection<Integer>> backups;

        SegmentBasedCollector(long id, Map<Address, Collection<Integer>> backups, int topologyId) {
            super(id, topologyId);
            this.backups = backups;
        }

        @Override
        public synchronized boolean hasPendingBackupAcks() {
            return !this.backups.isEmpty();
        }

        @Override
        public synchronized void onMembersChange(Collection<Address> members) {
            if (this.backups.keySet().retainAll(members)) {
                if (log.isTraceEnabled()) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.checkCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void primaryResult(T result, boolean success) {
            this.primaryResult = result;
            this.primaryResultReceived = true;
            SegmentBasedCollector segmentBasedCollector = this;
            synchronized (segmentBasedCollector) {
                this.checkCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void backupAck(Address from, int segment, int topologyId) {
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] PutMap Backup ACK. Address=%s. TopologyId=%s (expected=%s). Segment=%s", new Object[]{this.id, from, topologyId, this.topologyId, segment});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            SegmentBasedCollector segmentBasedCollector = this;
            synchronized (segmentBasedCollector) {
                Collection pendingSegments = this.backups.getOrDefault(from, Collections.emptyList());
                if (pendingSegments.remove(segment) && pendingSegments.isEmpty()) {
                    this.backups.remove(from);
                }
                this.checkCompleted();
            }
        }

        @GuardedBy(value="this")
        private void checkCompleted() {
            if (this.primaryResultReceived && this.backups.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.tracef("[Collector#%s] Ready! Return value=%ss.", this.id, this.primaryResult);
                }
                this.future.complete(this.primaryResult);
            }
        }

        @Override
        protected synchronized String getAddress() {
            return this.backups.keySet().toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SegmentBasedCollector{");
            sb.append("id=").append(this.id);
            sb.append(", topologyId=").append(this.topologyId);
            sb.append(", primaryResult=").append(this.primaryResult);
            sb.append(", primaryResultReceived=").append(this.primaryResultReceived);
            sb.append(", backups=").append(this.backups);
            sb.append('}');
            return sb.toString();
        }
    }

    public static interface MultiTargetCollector {
        public BiasedCollector collectorFor(Address var1);
    }

    private static class SingleTargetCollectorImpl
    implements BiasedCollector,
    Function<Void, CompletableFuture<ValidResponse>> {
        private final MultiTargetCollectorImpl parent;
        private final CompletableFuture<ValidResponse> resultFuture = new CompletableFuture();
        private final CompletableFuture<ValidResponse> combinedFuture;

        private SingleTargetCollectorImpl(MultiTargetCollectorImpl parent) {
            this.parent = parent;
            this.combinedFuture = CompletableFuture.allOf(this.resultFuture, parent.acksFuture).thenCompose((Function)this);
        }

        @Override
        public CompletableFuture<ValidResponse> getFuture() {
            return this.combinedFuture;
        }

        @Override
        public void primaryException(Throwable throwable) {
            this.combinedFuture.completeExceptionally(throwable);
        }

        @Override
        public void primaryResult(ValidResponse result, boolean success) {
            if (log.isTraceEnabled()) {
                log.tracef("Received result for %d, topology %d: %s", this.parent.id, this.parent.topologyId, result);
            }
            this.resultFuture.complete(result);
            this.parent.checkComplete();
        }

        @Override
        public CompletableFuture<ValidResponse> apply(Void nil) {
            return this.resultFuture;
        }

        @Override
        public void addPendingAcks(boolean success, Address[] waitFor) {
            if (success && waitFor != null) {
                this.parent.addPendingAcks(waitFor);
            }
        }
    }

    private abstract class BaseCollector<T>
    extends BaseAckTarget<T>
    implements Collector<T> {
        final CompletableFuture<T> future;
        final CompletableFuture<T> exposedFuture;
        volatile T primaryResult;
        volatile boolean primaryResultReceived;

        BaseCollector(long id, int topologyId) {
            super(id, topologyId);
            this.primaryResultReceived = false;
            this.future = new CompletableFuture();
            this.exposedFuture = this.future.whenComplete((BiConsumer)this);
        }

        @Override
        public final synchronized Void call() {
            this.future.completeExceptionally((Throwable)((Object)CommandAckCollector.this.createTimeoutException(this.getAddress(), this.id)));
            return null;
        }

        protected abstract String getAddress();

        @Override
        public final CompletableFuture<T> getFuture() {
            return this.exposedFuture;
        }

        @Override
        public void primaryException(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        @Override
        final void completeExceptionally(Throwable throwable, int topologyId) {
            if (log.isTraceEnabled()) {
                log.tracef(throwable, "[Collector#%s] completed exceptionally. TopologyId=%s (expected=%s)", this.id, topologyId, this.topologyId);
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            this.future.completeExceptionally(throwable);
        }

        final boolean isWrongTopologyOrIsDone(int topologyId) {
            return this.topologyId != topologyId || this.future.isDone();
        }
    }
}

