/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutEvents;
import io.smallrye.faulttolerance.core.timeout.TimeoutExecution;
import io.smallrye.faulttolerance.core.timeout.TimeoutLogger;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatch;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;

public class CompletionStageTimeout<V>
extends Timeout<CompletionStage<V>> {
    public CompletionStageTimeout(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, long timeoutInMillis, TimeoutWatcher watcher) {
        super(delegate, description, timeoutInMillis, watcher);
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        TimeoutLogger.LOG.trace("CompletionStageTimeout started");
        try {
            CompletionStage<V> completionStage = this.doApply(ctx);
            return completionStage;
        }
        finally {
            TimeoutLogger.LOG.trace("CompletionStageTimeout finished");
        }
    }

    private CompletionStage<V> doApply(InvocationContext<CompletionStage<V>> ctx) {
        CompletionStage<Object> originalResult;
        CompletableFuture result = new CompletableFuture();
        ctx.fireEvent(TimeoutEvents.Started.INSTANCE);
        AtomicBoolean completedWithTimeout = new AtomicBoolean(false);
        Runnable onTimeout = () -> {
            if (completedWithTimeout.compareAndSet(false, true)) {
                TimeoutLogger.LOG.debugf("%s invocation timed out (%d ms)", this.description, this.timeoutInMillis);
                ctx.fireEvent(TimeoutEvents.Finished.TIMED_OUT);
                result.completeExceptionally((Throwable)CompletionStageTimeout.timeoutException(this.description));
            }
        };
        TimeoutExecution timeoutExecution = new TimeoutExecution(null, this.timeoutInMillis, onTimeout);
        TimeoutWatch watch = this.watcher.schedule(timeoutExecution);
        try {
            originalResult = this.delegate.apply(ctx);
        }
        catch (Exception e) {
            originalResult = CompletionStages.failedStage(e);
        }
        originalResult.whenComplete((value, exception) -> {
            timeoutExecution.finish(watch::cancel);
            if (timeoutExecution.hasTimedOut()) {
                onTimeout.run();
            } else if (exception != null) {
                ctx.fireEvent(TimeoutEvents.Finished.NORMALLY);
                result.completeExceptionally((Throwable)exception);
            } else {
                ctx.fireEvent(TimeoutEvents.Finished.NORMALLY);
                result.complete(value);
            }
        });
        return result;
    }
}

