/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.UtilMessages;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class JandexUtil {
    private static final Pattern COMPONENT_KEY_PATTERN = Pattern.compile("^[a-zA-Z0-9\\.\\-_]+$");

    private JandexUtil() {
    }

    public static String createUniqueAnnotationTargetRef(AnnotationTarget annotationTarget) {
        switch (annotationTarget.kind()) {
            case FIELD: {
                return JandexUtil.createUniqueFieldRef(annotationTarget.asField());
            }
            case METHOD: {
                ClassInfo classInfo = annotationTarget.asMethod().declaringClass();
                return JandexUtil.createUniqueMethodReference(classInfo, annotationTarget.asMethod());
            }
            case METHOD_PARAMETER: {
                return JandexUtil.createUniqueMethodParameterRef(annotationTarget.asMethodParameter());
            }
        }
        return null;
    }

    public static String createUniqueFieldRef(FieldInfo fieldInfo) {
        ClassInfo classInfo = fieldInfo.declaringClass();
        return "f" + classInfo.hashCode() + "_" + fieldInfo.hashCode();
    }

    public static String createUniqueMethodReference(ClassInfo classInfo, MethodInfo methodInfo) {
        return "m" + classInfo.hashCode() + "_" + methodInfo.hashCode();
    }

    public static String createUniqueMethodParameterRef(MethodParameterInfo methodParameter) {
        MethodInfo methodInfo = methodParameter.method();
        ClassInfo classInfo = methodInfo.declaringClass();
        return "p" + classInfo.hashCode() + "_" + methodInfo.hashCode() + "_" + methodParameter.position();
    }

    public static String refValue(AnnotationInstance annotation, RefType refType) {
        AnnotationValue value = annotation.value("ref");
        if (value == null) {
            return null;
        }
        String ref = value.asString();
        if (!COMPONENT_KEY_PATTERN.matcher(ref).matches()) {
            return ref;
        }
        if (refType == null) {
            throw UtilMessages.msg.refTypeNotNull();
        }
        ref = "#/components/" + refType.componentPath + "/" + ref;
        return ref;
    }

    public static boolean isRef(AnnotationInstance annotation) {
        return annotation != null && annotation.value("ref") != null;
    }

    public static boolean isEmpty(AnnotationInstance annotation) {
        return annotation.values() == null || annotation.values().isEmpty();
    }

    public static String nameFromRef(AnnotationInstance annotation) {
        String ref = annotation.value("ref").asString();
        return ModelUtil.nameFromRef(ref);
    }

    public static List<AnnotationValue> schemaDisplayValues(AnnotationInstance annotation) {
        return annotation.values().stream().filter(value -> !SchemaConstant.PROPERTIES_NONDISPLAY.contains(value.name())).collect(Collectors.toList());
    }

    public static boolean isSimpleClassSchema(AnnotationInstance annotation) {
        return JandexUtil.schemaDisplayValues(annotation).isEmpty() && JandexUtil.hasImplementation(annotation);
    }

    public static boolean isSimpleArraySchema(AnnotationInstance annotation) {
        if (JandexUtil.schemaDisplayValues(annotation).size() != 1) {
            return false;
        }
        return JandexUtil.isArraySchema(annotation);
    }

    public static boolean isArraySchema(AnnotationInstance annotation) {
        if (!JandexUtil.hasImplementation(annotation)) {
            return false;
        }
        Schema.SchemaType type = Annotations.enumValue(annotation, "type", Schema.SchemaType.class);
        return type == Schema.SchemaType.ARRAY;
    }

    public static boolean hasImplementation(AnnotationInstance annotation) {
        return annotation.value("implementation") != null;
    }

    public static boolean equals(AnnotationTarget t1, AnnotationTarget t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null || t1.kind() != t2.kind()) {
            return false;
        }
        switch (t1.kind()) {
            case CLASS: {
                return JandexUtil.equals(t1.asClass(), t2.asClass());
            }
            case FIELD: {
                return JandexUtil.equals(t1.asField(), t2.asField());
            }
            case METHOD_PARAMETER: {
                return JandexUtil.equals(t1.asMethodParameter(), t2.asMethodParameter());
            }
        }
        return t1.equals(t2);
    }

    public static boolean equals(ClassInfo c1, ClassInfo c2) {
        return c1.name().equals((Object)c2.name());
    }

    public static boolean equals(FieldInfo f1, FieldInfo f2) {
        return JandexUtil.equals(f1.declaringClass(), f2.declaringClass()) && f1.name().equals(f2.name());
    }

    public static boolean equals(MethodParameterInfo p1, MethodParameterInfo p2) {
        return p1.method().equals((Object)p2.method()) && p1.position() == p2.position();
    }

    public static List<FieldInfo> fields(AnnotationScannerContext context, ClassInfo currentClass) {
        if (context.getConfig().sortedPropertiesEnable()) {
            return currentClass.fields();
        }
        return currentClass.unsortedFields();
    }

    public static boolean isSupplier(AnnotationTarget target) {
        if (target.kind() != AnnotationTarget.Kind.METHOD) {
            return false;
        }
        MethodInfo method = target.asMethod();
        return method.returnType().kind() != Type.Kind.VOID && method.parameterTypes().isEmpty();
    }

    public static enum RefType {
        HEADER("headers"),
        SCHEMA("schemas"),
        SECURITY_SCHEME("securitySchemes"),
        CALLBACK("callbacks"),
        LINK("links"),
        RESPONSE("responses"),
        PARAMETER("parameters"),
        EXAMPLE("examples"),
        REQUEST_BODY("requestBodies");

        String componentPath;

        private RefType(String componentPath) {
            this.componentPath = componentPath;
        }

        public static RefType fromComponentPath(String path) {
            for (RefType ref : RefType.values()) {
                if (!ref.componentPath.equals(path)) continue;
                return ref;
            }
            return null;
        }
    }
}

