/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.extensions;

import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.jts.extensions.TxAssociation;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.SystemException;

public class ThreadAssociations {
    private static Hashtable txAssociations = new Hashtable();
    private static Vector globalTxAssociations = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean add(TxAssociation tx2) {
        Vector<TxAssociation> v;
        if (tx2 == null) {
            return false;
        }
        Thread ct = Thread.currentThread();
        Hashtable hashtable = txAssociations;
        synchronized (hashtable) {
            v = (Vector<TxAssociation>)txAssociations.get(tx2);
            if (v == null) {
                v = new Vector<TxAssociation>();
                txAssociations.put(ct, v);
            }
        }
        v.addElement(tx2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean addGlobal(TxAssociation tx2) {
        if (tx2 == null) {
            return false;
        }
        Vector vector = globalTxAssociations;
        synchronized (vector) {
            globalTxAssociations.addElement(tx2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean remove(TxAssociation tx2) {
        if (tx2 == null) {
            return false;
        }
        Hashtable hashtable = txAssociations;
        synchronized (hashtable) {
            Thread ct = Thread.currentThread();
            Vector v = (Vector)txAssociations.get(ct);
            v.removeElement(tx2);
            if (v.isEmpty()) {
                txAssociations.remove(ct);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean removeGlobal(TxAssociation tx2) {
        if (tx2 == null) {
            return false;
        }
        Vector vector = globalTxAssociations;
        synchronized (vector) {
            globalTxAssociations.removeElement(tx2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean removeAll(boolean global) {
        if (global) {
            Vector vector = globalTxAssociations;
            synchronized (vector) {
                globalTxAssociations.removeAllElements();
                globalTxAssociations = null;
            }
        }
        Hashtable hashtable = txAssociations;
        synchronized (hashtable) {
            txAssociations.clear();
            txAssociations = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void updateAssociation(ControlWrapper tx2, int reason) {
        try {
            Cloneable cloneable = txAssociations;
            synchronized (cloneable) {
                Vector v = (Vector)txAssociations.get(Thread.currentThread());
                if (v != null) {
                    for (int i = 0; i < v.size(); ++i) {
                        TxAssociation ta = (TxAssociation)v.elementAt(i);
                        try {
                            if (ta == null) continue;
                            ThreadAssociations.update(ta, tx2, reason);
                            continue;
                        }
                        catch (SystemException e) {
                            jtsLogger.i18NLogger.warn_extensions_threadasserror("ThreadAssociations.updateAssociations", e);
                        }
                    }
                }
            }
            cloneable = globalTxAssociations;
            synchronized (cloneable) {
                for (int i = 0; i < globalTxAssociations.size(); ++i) {
                    TxAssociation ta = (TxAssociation)globalTxAssociations.elementAt(i);
                    try {
                        if (ta == null) continue;
                        ThreadAssociations.update(ta, tx2, reason);
                        continue;
                    }
                    catch (SystemException e) {
                        jtsLogger.i18NLogger.warn_extensions_threadasserror("ThreadAssociations.updateAssociations", e);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void update(TxAssociation ta, ControlWrapper tx2, int reason) throws SystemException {
        switch (reason) {
            case 0: {
                ta.begin(tx2);
                break;
            }
            case 1: {
                ta.commit(tx2);
                break;
            }
            case 2: {
                ta.rollback(tx2);
                break;
            }
            case 3: {
                ta.suspend(tx2);
                break;
            }
            case 4: {
                ta.resume(tx2);
                break;
            }
        }
    }
}

