/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;

public class WrappedService
implements Service {
    private Service wrappedService;
    private DataBinding dataBinding;
    private QName name;
    private List<ServiceInfo> serviceInfos;
    private Map<QName, Endpoint> endpoints;
    private Invoker invoker;

    WrappedService(Service wrapped, QName n, ServiceInfo info) {
        this.wrappedService = wrapped;
        this.name = n;
        this.serviceInfos = Collections.singletonList(info);
    }

    public Service getWrappedService() {
        return this.wrappedService;
    }

    public DataBinding getDataBinding() {
        return this.dataBinding;
    }

    public QName getName() {
        return this.name;
    }

    public List<ServiceInfo> getServiceInfos() {
        return this.serviceInfos;
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfos.get(0);
    }

    public void setDataBinding(DataBinding arg0) {
        this.dataBinding = arg0;
    }

    public Map<QName, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker arg0) {
        this.invoker = arg0;
    }

    public Executor getExecutor() {
        return this.wrappedService.getExecutor();
    }

    public void setExecutor(Executor arg0) {
        this.wrappedService.setExecutor(arg0);
    }

    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.wrappedService.getInFaultInterceptors();
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.wrappedService.getInInterceptors();
    }

    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.wrappedService.getOutFaultInterceptors();
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.wrappedService.getOutInterceptors();
    }

    public void clear() {
        this.wrappedService.clear();
    }

    public boolean containsKey(Object key) {
        return this.wrappedService.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.wrappedService.containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.wrappedService.entrySet();
    }

    public Object get(Object key) {
        return this.wrappedService.get(key);
    }

    public boolean isEmpty() {
        return this.wrappedService.isEmpty();
    }

    public Set<String> keySet() {
        return this.wrappedService.keySet();
    }

    public Object put(String key, Object value) {
        return this.wrappedService.put((Object)key, value);
    }

    public void putAll(Map<? extends String, ? extends Object> t) {
        this.wrappedService.putAll(t);
    }

    public Object remove(Object key) {
        return this.wrappedService.remove(key);
    }

    public int size() {
        return this.wrappedService.size();
    }

    public Collection<Object> values() {
        return this.wrappedService.values();
    }

    void setEndpoint(Endpoint e) {
        this.endpoints = Collections.singletonMap(e.getEndpointInfo().getName(), e);
    }

    public EndpointInfo getEndpointInfo(QName endpoint) {
        return this.serviceInfos.get(0).getEndpoint(endpoint);
    }
}

