/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.patching.cli.PatchIdCompleter;
import org.jboss.as.patching.cli.PatchOverrideCommand;
import org.jboss.as.patching.cli.PatchRollbackActivator;
import org.jboss.as.patching.tool.PatchOperationBuilder;
import org.wildfly.core.cli.command.aesh.activator.HideOptionActivator;

@CommandDefinition(name="rollback", description="", activator=PatchRollbackActivator.class)
public class PatchRollback
extends PatchOverrideCommand {
    @Option(name="reset-configuration", hasValue=true, required=true)
    private boolean resetConfiguration;
    @Option(name="rollback-to", hasValue=false, required=false)
    private boolean rollbackTo;
    @Option(name="patch-stream", hasValue=true, required=false)
    private String patchStream;
    @Option(name="patch-id", required=false, activator=HideOptionActivator.class)
    private String patchId;
    @Argument(completer=PatchIdCompleter.class)
    private String patchIdArg;

    public PatchRollback(String action) {
        super("rollback");
    }

    private String getPatchId() throws CommandException {
        if (this.patchId != null && this.patchIdArg != null) {
            throw new CommandException("patch-id argument and options can't be set al together.");
        }
        if (this.patchId != null) {
            return this.patchId;
        }
        if (this.patchIdArg != null) {
            return this.patchIdArg;
        }
        return null;
    }

    @Override
    protected PatchOperationBuilder createUnconfiguredOperationBuilder(CommandContext ctx) throws CommandException {
        String patchId = this.getPatchId();
        PatchOperationBuilder builder = patchId != null ? PatchOperationBuilder.Factory.rollback(this.patchStream, patchId, this.rollbackTo, this.resetConfiguration) : PatchOperationBuilder.Factory.rollbackLast(this.patchStream, this.resetConfiguration);
        return builder;
    }

    @Override
    String getPatchStream() {
        return this.patchStream;
    }
}

