/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.ejb.infinispan.timer.IntervalTimerCreationMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.IntervalTimerCreationMetaDataEntry;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;

public class IntervalTimerCreationMetaDataMarshaller
implements ProtoStreamMarshaller<IntervalTimerCreationMetaData<Object>> {
    private static final int INFO_INDEX = 1;
    private static final int START_INDEX = 2;
    private static final int INTERVAL_INDEX = 3;
    private static final Instant DEFAULT_START = Instant.EPOCH;

    public Class<? extends IntervalTimerCreationMetaData<Object>> getJavaClass() {
        return IntervalTimerCreationMetaDataEntry.class;
    }

    public IntervalTimerCreationMetaData<Object> readFrom(ProtoStreamReader reader) throws IOException {
        MarshalledValue context = null;
        Instant start = DEFAULT_START;
        Duration interval = null;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    context = (MarshalledValue)reader.readObject(ByteBufferMarshalledValue.class);
                    continue block5;
                }
                case 2: {
                    start = (Instant)reader.readObject(Instant.class);
                    continue block5;
                }
                case 3: {
                    interval = (Duration)reader.readObject(Duration.class);
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return new IntervalTimerCreationMetaDataEntry<Object>(context, start, interval);
    }

    public void writeTo(ProtoStreamWriter writer, IntervalTimerCreationMetaData<Object> metaData) throws IOException {
        Duration interval;
        Instant start;
        Object context = metaData.getContext();
        if (context != null) {
            writer.writeObject(1, context);
        }
        if (!(start = metaData.getStart()).equals(DEFAULT_START)) {
            writer.writeObject(2, (Object)start);
        }
        if ((interval = metaData.getInterval()) != null) {
            writer.writeObject(3, (Object)interval);
        }
    }
}

