/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    DATA_SOURCE("data-source"),
    NAME("name"),
    VALUE("value"),
    EXECUTION_RECORDS_LIMIT("execution-records-limit");

    private static final Map<String, Attribute> MAP;
    private final String name;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        if (localName == null) {
            return UNKNOWN;
        }
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        MAP = Map.of(Attribute.DATA_SOURCE.name, DATA_SOURCE, Attribute.NAME.name, NAME, Attribute.VALUE.name, VALUE, Attribute.EXECUTION_RECORDS_LIMIT.name, EXECUTION_RECORDS_LIMIT);
    }
}

