/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.composite;

import com.sun.faces.util.Util;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.AttachedObjectTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AttachedObjectTargetImpl
implements AttachedObjectTarget {
    private String name = null;
    private ValueExpression targetsList;

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public List<UIComponent> getTargets(UIComponent topLevelComponent) {
        ArrayList<Object> result;
        assert (null != this.name);
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (null != this.targetsList) {
            String targetsListStr = (String)this.targetsList.getValue(ctx.getELContext());
            Map appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
            String[] targetArray = Util.split(appMap, targetsListStr, " ");
            result = new ArrayList(targetArray.length);
            int len = targetArray.length;
            for (int i = 0; i < len; ++i) {
                UIComponent comp = topLevelComponent.findComponent(this.augmentSearchId(ctx, topLevelComponent, targetArray[i]));
                if (null == comp) continue;
                result.add(comp);
            }
        } else {
            result = new ArrayList<UIComponent>(1);
            UIComponent comp = topLevelComponent.findComponent(this.augmentSearchId(ctx, topLevelComponent, this.name));
            if (null != comp) {
                result.add(comp);
            }
        }
        return result;
    }

    void setTargetsList(ValueExpression targetsList) {
        this.targetsList = targetsList;
    }

    ValueExpression getTargetsList() {
        return this.targetsList;
    }

    private String augmentSearchId(FacesContext ctx, UIComponent c, String targetId) {
        if (targetId.equals(c.getId())) {
            return targetId + UINamingContainer.getSeparatorChar((FacesContext)ctx) + targetId;
        }
        return targetId;
    }
}

