/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.Closeable;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jgroups.Address;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.cs.NioBaseServer;
import org.jgroups.blocks.cs.NioConnection;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class NioServer
extends NioBaseServer {
    protected ServerSocketChannel channel;

    public NioServer(InetAddress bind_addr, int port) throws Exception {
        this(new DefaultThreadFactory("nio", false), new DefaultSocketFactory(), bind_addr, port, port + 50, null, 0, 0);
    }

    public NioServer(ThreadFactory thread_factory, SocketFactory socket_factory, InetAddress bind_addr, int srv_port, int end_port, InetAddress external_addr, int external_port, int recv_buf_size) throws Exception {
        this(thread_factory, socket_factory, bind_addr, srv_port, end_port, external_addr, external_port, recv_buf_size, "jgroups.nio.server");
    }

    public NioServer(ThreadFactory thread_factory, SocketFactory socket_factory, InetAddress bind_addr, int srv_port, int end_port, InetAddress external_addr, int external_port, int recv_buf_size, String service_name) throws Exception {
        super(thread_factory, socket_factory, recv_buf_size);
        this.channel = Util.createServerSocketChannel(this.socket_factory, service_name, bind_addr, srv_port, end_port, recv_buf_size);
        this.channel.configureBlocking(false);
        this.selector = Selector.open();
        this.acceptor = this.factory.newThread(new NioBaseServer.Acceptor(), "NioServer.Selector [" + this.channel.getLocalAddress() + "]");
        this.channel.register(this.selector, 16, null);
        this.local_addr = NioServer.localAddress(bind_addr, this.channel.socket().getLocalPort(), external_addr, external_port);
    }

    public ServerSocketChannel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleAccept(SelectionKey key) throws Exception {
        SocketChannel client_channel = this.channel.accept();
        NioConnection conn = null;
        if (client_channel == null) {
            return;
        }
        try {
            conn = new NioConnection(client_channel, (NioBaseServer)this);
            SelectionKey client_key = client_channel.register(this.selector, 1, conn);
            conn.key(client_key);
            Address peer_addr = conn.peerAddress();
            if (this.use_peer_connections) {
                return;
            }
            NioServer nioServer = this;
            synchronized (nioServer) {
                this.replaceConnection(peer_addr, conn);
                conn.start();
                this.log.trace("%s: accepted connection from %s", this.local_addr, peer_addr);
            }
        }
        catch (Throwable ex) {
            Util.close(conn);
            this.removeConnectionIfPresent(conn.peerAddress(), conn);
            throw ex;
        }
    }

    @Override
    @ManagedOperation(description="Starts the server")
    public synchronized void start() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            this.acceptor.start();
            super.start();
        }
    }

    @Override
    @ManagedOperation(description="Stops the server")
    public synchronized void stop() {
        super.stop();
        if (this.running.compareAndSet(true, false)) {
            this.selector.wakeup();
            Util.interruptAndWaitToDie(this.acceptor);
        }
    }

    @Override
    protected void acceptorDone() {
        Util.close((Closeable)this.selector);
        this.socket_factory.close(this.channel);
    }
}

