/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyWithMetadataMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.MultimapOperationsFactory;
import org.infinispan.client.hotrod.impl.multimap.operations.PutKeyValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveKeyMultimapOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.multimap.MetadataCollection;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCache;
import org.infinispan.commons.marshall.AdaptiveBufferSizePredictor;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;

public class RemoteMultimapCacheImpl<K, V>
implements RemoteMultimapCache<K, V> {
    private static final Log log = LogFactory.getLog(RemoteMultimapCacheImpl.class, Log.class);
    private final InternalRemoteCache<K, Collection<V>> cache;
    private final RemoteCacheManager remoteCacheManager;
    private MultimapOperationsFactory operationsFactory;
    private Marshaller marshaller;
    private final BufferSizePredictor keySizePredictor = new AdaptiveBufferSizePredictor();
    private final BufferSizePredictor valueSizePredictor = new AdaptiveBufferSizePredictor();
    private long defaultLifespan = 0L;
    private long defaultMaxIdleTime = 0L;
    private final boolean supportsDuplicates;

    public void init() {
        this.operationsFactory = new MultimapOperationsFactory(this.remoteCacheManager.getChannelFactory(), this.cache.getName(), this.remoteCacheManager.getConfiguration(), this.cache.getDataFormat(), this.cache.clientStatistics());
        this.marshaller = this.remoteCacheManager.getMarshaller();
    }

    public RemoteMultimapCacheImpl(RemoteCacheManager rcm, RemoteCache<K, Collection<V>> cache) {
        this(rcm, cache, false);
    }

    public RemoteMultimapCacheImpl(RemoteCacheManager rcm, RemoteCache<K, Collection<V>> cache, boolean supportsDuplicates) {
        if (log.isTraceEnabled()) {
            log.tracef("Creating multimap remote cache: %s", cache.getName());
        }
        this.cache = (RemoteCacheImpl)cache;
        this.remoteCacheManager = rcm;
        this.supportsDuplicates = supportsDuplicates;
    }

    public CompletableFuture<Void> put(K key, V value) {
        if (log.isTraceEnabled()) {
            log.tracef("About to add (K,V): (%s, %s) lifespan:%d, maxIdle:%d", new Object[]{key, value, this.defaultLifespan, this.defaultMaxIdleTime});
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor);
        PutKeyValueMultimapOperation op = this.operationsFactory.newPutKeyValueOperation(objectKey, marshallKey, marshallValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS, this.supportsDuplicates);
        return op.execute();
    }

    public CompletableFuture<Collection<V>> get(K key) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call get (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        GetKeyMultimapOperation gco = this.operationsFactory.newGetKeyMultimapOperation(objectKey, marshallKey, this.supportsDuplicates);
        return gco.execute();
    }

    @Override
    public CompletableFuture<MetadataCollection<V>> getWithMetadata(K key) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call getWithMetadata (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        GetKeyWithMetadataMultimapOperation operation = this.operationsFactory.newGetKeyWithMetadataMultimapOperation(objectKey, marshallKey, this.supportsDuplicates);
        return operation.execute();
    }

    public CompletableFuture<Boolean> remove(K key) {
        if (log.isTraceEnabled()) {
            log.tracef("About to remove (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        RemoveKeyMultimapOperation removeOperation = this.operationsFactory.newRemoveKeyOperation(objectKey, marshallKey, this.supportsDuplicates);
        return removeOperation.execute();
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        if (log.isTraceEnabled()) {
            log.tracef("About to remove (K,V): (%s, %s)", key, value);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor);
        RemoveEntryMultimapOperation removeOperation = this.operationsFactory.newRemoveEntryOperation(objectKey, marshallKey, marshallValue, this.supportsDuplicates);
        return removeOperation.execute();
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call contains (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        ContainsKeyMultimapOperation containsKeyOperation = this.operationsFactory.newContainsKeyOperation(objectKey, marshallKey, this.supportsDuplicates);
        return containsKeyOperation.execute();
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call contains (V): (%s)", value);
        }
        this.assertRemoteCacheManagerIsStarted();
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor);
        ContainsValueMultimapOperation containsValueOperation = this.operationsFactory.newContainsValueOperation(marshallValue, this.supportsDuplicates);
        return containsValueOperation.execute();
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call contais(K,V): (%s, %s)", key, value);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor);
        ContainsEntryMultimapOperation containsOperation = this.operationsFactory.newContainsEntryOperation(objectKey, marshallKey, marshallValue, this.supportsDuplicates);
        return containsOperation.execute();
    }

    public CompletableFuture<Long> size() {
        if (log.isTraceEnabled()) {
            log.trace("About to call size");
        }
        this.assertRemoteCacheManagerIsStarted();
        return this.operationsFactory.newSizeOperation(this.supportsDuplicates).execute();
    }

    public boolean supportsDuplicates() {
        return this.supportsDuplicates;
    }

    private void assertRemoteCacheManagerIsStarted() {
        if (!this.remoteCacheManager.isStarted()) {
            String message = "Cannot perform operations on a multimap cache associated with an unstarted RemoteMultimapCacheManager.";
            if (log.isInfoEnabled()) {
                log.unstartedRemoteCacheManager();
            }
            throw new RemoteCacheManagerNotStartedException(message);
        }
    }

    private boolean isObjectStorage() {
        return this.cache.isObjectStorage();
    }
}

