/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;

public class PathDefinition
extends PersistentResourceDefinition {
    static final String DEFAULT_RELATIVE_TO = "jboss.server.data.dir";
    private static final SimpleAttributeDefinition PATH_BASE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PathResourceDefinition.PATH).setAllowExpression(true)).setRequired(false)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PathResourceDefinition.RELATIVE_TO).setDefaultValue(new ModelNode("jboss.server.data.dir"))).setRequired(false)).setRestartAllServices()).build();
    protected static final Map<String, SimpleAttributeDefinition> PATHS = new HashMap<String, SimpleAttributeDefinition>();
    private static final String DEFAULT_PATH = "activemq";
    static final String DEFAULT_BINDINGS_DIR = "activemq" + File.separator + "bindings";
    static final String DEFAULT_JOURNAL_DIR = "activemq" + File.separator + "journal";
    static final String DEFAULT_LARGE_MESSAGE_DIR = "activemq" + File.separator + "largemessages";
    static final String DEFAULT_PAGING_DIR = "activemq" + File.separator + "paging";
    static final OperationStepHandler PATH_ADD;
    static final OperationStepHandler PATH_REMOVE;
    private final PathElement path;

    static final AttributeDefinition[] getAttributes(String path) {
        return new AttributeDefinition[]{(AttributeDefinition)PATHS.get(path), RELATIVE_TO};
    }

    PathDefinition(PathElement path) {
        super(path, MessagingExtension.getResourceDescriptionResolver("path"), PATH_ADD, PATH_REMOVE);
        this.path = path;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(PathDefinition.getAttributes(this.getPathElement().getValue()));
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        AttributeDefinition[] attributes = PathDefinition.getAttributes(this.path.getValue());
        ReloadRequiredWriteAttributeHandler attributeHandler = new ReloadRequiredWriteAttributeHandler(attributes);
        for (AttributeDefinition attribute : attributes) {
            registry.registerReadWriteAttribute(attribute, null, (OperationStepHandler)attributeHandler);
        }
    }

    public int getMinOccurs() {
        return 1;
    }

    protected static void registerResolveOperationHandler(ExtensionContext context, ManagementResourceRegistration registry) {
        if (context.getProcessType().isServer()) {
            ResolvePathHandler resolvePathHandler = ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)PATHS.get(registry.getPathAddress().getLastElement().getValue())).setRelativeToAttribute((AttributeDefinition)RELATIVE_TO).setCheckAbsolutePath(true).build();
            registry.registerOperationHandler(resolvePathHandler.getOperationDefinition(), (OperationStepHandler)resolvePathHandler);
        }
    }

    static void reloadRequiredStep(OperationContext context) {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    OperationContext.RollbackHandler rh;
                    ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
                    ServiceController controller = context.getServiceRegistry(false).getService(serviceName);
                    if (controller != null) {
                        context.reloadRequired();
                        rh = OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER;
                    } else {
                        rh = OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER;
                    }
                    context.completeStep(rh);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static {
        PATHS.put("bindings-directory", ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PATH_BASE).setDefaultValue(new ModelNode(DEFAULT_BINDINGS_DIR))).build());
        PATHS.put("journal-directory", ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PATH_BASE).setDefaultValue(new ModelNode(DEFAULT_JOURNAL_DIR))).build());
        PATHS.put("large-messages-directory", ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PATH_BASE).setDefaultValue(new ModelNode(DEFAULT_LARGE_MESSAGE_DIR))).build());
        PATHS.put("paging-directory", ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PATH_BASE).setDefaultValue(new ModelNode(DEFAULT_PAGING_DIR))).build());
        PATH_ADD = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
                ModelNode model = resource.getModel();
                String path = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                for (AttributeDefinition attribute : PathDefinition.getAttributes(path)) {
                    attribute.validateAndSet(operation, model);
                }
                PathDefinition.reloadRequiredStep(context);
            }
        };
        PATH_REMOVE = new AbstractRemoveStepHandler(){

            protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                super.performRemove(context, operation, model);
                PathDefinition.reloadRequiredStep(context);
            }
        };
    }
}

