/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class IndexOrUniqueKeySecondPass
implements SecondPass {
    private Table table;
    private final String indexName;
    private final String[] columns;
    private final MetadataBuildingContext buildingContext;
    private final AnnotatedColumn column;
    private final boolean unique;

    public IndexOrUniqueKeySecondPass(Table table, String indexName, String[] columns, MetadataBuildingContext buildingContext) {
        this.table = table;
        this.indexName = indexName;
        this.columns = columns;
        this.buildingContext = buildingContext;
        this.column = null;
        this.unique = false;
    }

    public IndexOrUniqueKeySecondPass(String indexName, AnnotatedColumn column, MetadataBuildingContext buildingContext, boolean unique) {
        this.indexName = indexName;
        this.column = column;
        this.columns = null;
        this.buildingContext = buildingContext;
        this.unique = unique;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        if (this.columns != null) {
            for (String columnName : this.columns) {
                this.addConstraintToColumn(columnName);
            }
        }
        if (this.column != null) {
            this.table = this.column.getParent().getTable();
            PropertyHolder propertyHolder = this.column.getParent().getPropertyHolder();
            String entityName = propertyHolder.isComponent() ? propertyHolder.getPersistentClass().getEntityName() : propertyHolder.getEntityName();
            PersistentClass persistentClass = persistentClasses.get(entityName);
            Property property = persistentClass.getProperty(this.column.getParent().getPropertyName());
            if (property.getValue() instanceof Component) {
                Component component = (Component)property.getValue();
                ArrayList<Column> columns = new ArrayList<Column>();
                for (Selectable selectable : component.getSelectables()) {
                    if (!(selectable instanceof Column)) continue;
                    columns.add((Column)selectable);
                }
                this.addConstraintToColumns(columns);
            } else {
                this.addConstraintToColumn(this.buildingContext.getMetadataCollector().getLogicalColumnName(this.table, this.column.getMappingColumn().getQuotedName()));
            }
        }
    }

    private void addConstraintToColumn(String columnName) {
        Column column = this.table.getColumn(this.buildingContext.getMetadataCollector(), columnName);
        if (column == null) {
            throw new AnnotationException("Table '" + this.table.getName() + "' has no column named '" + columnName + "' matching the column specified in '@Index'");
        }
        if (this.unique) {
            this.table.getOrCreateUniqueKey(this.indexName).addColumn(column);
        } else {
            this.table.getOrCreateIndex(this.indexName).addColumn(column);
        }
    }

    private void addConstraintToColumns(List<Column> columns) {
        if (this.unique) {
            UniqueKey uniqueKey = this.table.getOrCreateUniqueKey(this.indexName);
            for (Column column : columns) {
                uniqueKey.addColumn(column);
            }
        } else {
            Index index = this.table.getOrCreateIndex(this.indexName);
            for (Column column : columns) {
                index.addColumn(column);
            }
        }
    }
}

