/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hibernate.Internal;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.persister.entity.EntityPersister;

public class NaturalIdCacheKey
implements Serializable {
    private final Object naturalIdValues;
    private final String entityName;
    private final String tenantId;
    private final int hashCode;
    private transient ValueHolder<String> toString;

    @Internal
    public NaturalIdCacheKey(Object naturalIdValues, String entityName, String tenantId, int hashCode) {
        this.naturalIdValues = naturalIdValues;
        this.entityName = entityName;
        this.tenantId = tenantId;
        this.hashCode = hashCode;
        this.initTransients();
    }

    private void initTransients() {
        this.toString = new ValueHolder<ValueHolder.DeferredInitializer<String>>(() -> {
            StringBuilder toStringBuilder = new StringBuilder().append(this.entityName).append("##NaturalId[");
            if (this.naturalIdValues instanceof Object[]) {
                Object[] values = (Object[])this.naturalIdValues;
                for (int i = 0; i < values.length; ++i) {
                    toStringBuilder.append(values[i]);
                    if (i + 1 >= values.length) continue;
                    toStringBuilder.append(", ");
                }
            } else {
                toStringBuilder.append(this.naturalIdValues);
            }
            return toStringBuilder.toString();
        });
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Object getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public String toString() {
        return this.toString.getValue();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.hashCode != o.hashCode() || !(o instanceof NaturalIdCacheKey)) {
            return false;
        }
        NaturalIdCacheKey other = (NaturalIdCacheKey)o;
        return Objects.equals(this.entityName, other.entityName) && Objects.equals(this.tenantId, other.tenantId) && Objects.deepEquals(this.naturalIdValues, other.naturalIdValues);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.initTransients();
    }

    public static class NaturalIdCacheKeyBuilder
    implements MutableCacheKeyBuilder {
        private final String entityName;
        private final String tenantIdentifier;
        private final List<Object> values;
        private int hashCode;

        public NaturalIdCacheKeyBuilder(Object naturalIdValues, EntityPersister persister, String entityName, SharedSessionContractImplementor session) {
            this.entityName = entityName;
            this.tenantIdentifier = session.getTenantIdentifier();
            this.values = new ArrayList<Object>();
            persister.getNaturalIdMapping().addToCacheKey(this, naturalIdValues, session);
        }

        public NaturalIdCacheKeyBuilder(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
            this(naturalIdValues, persister, persister.getRootEntityName(), session);
        }

        @Override
        public void addValue(Object value) {
            this.values.add(value);
        }

        @Override
        public void addHashCode(int hashCode) {
            this.hashCode = 37 * this.hashCode + hashCode;
        }

        @Override
        public NaturalIdCacheKey build() {
            return new NaturalIdCacheKey(this.values.toArray(new Object[0]), this.entityName, this.tenantIdentifier, this.hashCode);
        }
    }
}

