/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.util.Comparator;
import java.util.TimeZone;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;

public class TimeZoneJavaType
extends AbstractClassJavaType<TimeZone> {
    public static final TimeZoneJavaType INSTANCE = new TimeZoneJavaType();

    public TimeZoneJavaType() {
        super(TimeZone.class, ImmutableMutabilityPlan.instance(), TimeZoneComparator.INSTANCE);
    }

    @Override
    public String toString(TimeZone value) {
        return value.getID();
    }

    @Override
    public TimeZone fromString(CharSequence string) {
        return TimeZone.getTimeZone(string.toString());
    }

    @Override
    public <X> X unwrap(TimeZone value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> TimeZone wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return this.fromString((CharSequence)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class TimeZoneComparator
    implements Comparator<TimeZone> {
        public static final TimeZoneComparator INSTANCE = new TimeZoneComparator();

        @Override
        public int compare(TimeZone o1, TimeZone o2) {
            return o1.getID().compareTo(o2.getID());
        }
    }
}

