/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.JsonHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;

public class OracleJsonBlobJdbcType
implements AggregateJdbcType {
    public static final OracleJsonBlobJdbcType INSTANCE = new OracleJsonBlobJdbcType(null);
    private final EmbeddableMappingType embeddableMappingType;

    protected OracleJsonBlobJdbcType(EmbeddableMappingType embeddableMappingType) {
        this.embeddableMappingType = embeddableMappingType;
    }

    @Override
    public int getJdbcTypeCode() {
        return 2004;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3001;
    }

    public String toString() {
        return "JsonBlobJdbcType";
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return null;
    }

    @Override
    public String getCheckCondition(String columnName, JavaType<?> javaType, Dialect dialect) {
        return columnName + " is json";
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new OracleJsonBlobJdbcType(mappingType);
    }

    @Override
    public EmbeddableMappingType getEmbeddableMappingType() {
        return this.embeddableMappingType;
    }

    protected <X> X fromString(String string, JavaType<X> javaType, WrapperOptions options) throws SQLException {
        if (this.embeddableMappingType != null) {
            return JsonHelper.fromString(this.embeddableMappingType, string, javaType.getJavaTypeClass() != Object[].class, options);
        }
        return options.getSessionFactory().getFastSessionServices().getJsonFormatMapper().fromString(string, javaType, options);
    }

    @Override
    public Object createJdbcValue(Object domainValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        return JsonHelper.toString(this.embeddableMappingType, domainValue, options);
    }

    @Override
    public Object[] extractJdbcValues(Object rawJdbcValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        return (Object[])JsonHelper.fromString(this.embeddableMappingType, (String)rawJdbcValue, false, options);
    }

    protected <X> String toString(X value, JavaType<X> javaType, WrapperOptions options) {
        if (this.embeddableMappingType != null) {
            return JsonHelper.toString(this.embeddableMappingType, value, options);
        }
        return options.getSessionFactory().getFastSessionServices().getJsonFormatMapper().toString(value, javaType, options);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String json = OracleJsonBlobJdbcType.this.toString(value, this.getJavaType(), options);
                st.setBytes(index, json.getBytes(StandardCharsets.UTF_8));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String json = OracleJsonBlobJdbcType.this.toString(value, this.getJavaType(), options);
                st.setBytes(name, json.getBytes(StandardCharsets.UTF_8));
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.fromString(rs.getBytes(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.fromString(statement.getBytes(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.fromString(statement.getBytes(name), options);
            }

            private X fromString(byte[] json, WrapperOptions options) throws SQLException {
                if (json == null) {
                    return null;
                }
                return OracleJsonBlobJdbcType.this.fromString(new String(json, StandardCharsets.UTF_8), this.getJavaType(), options);
            }
        };
    }
}

