/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import org.infinispan.commons.util.CloseableIterator;

public class MappingEntryIterator<K, S, T>
implements CloseableIterator<T> {
    private final CloseableIterator<Map.Entry<K, S>> entryIterator;
    private final BiFunction<K, S, T> mapper;
    private long skip = 0L;
    private long max = -1L;
    private T current;
    private long index;

    public MappingEntryIterator(CloseableIterator<Map.Entry<K, S>> entryIterator, BiFunction<K, S, T> mapper) {
        this.entryIterator = entryIterator;
        this.mapper = mapper;
    }

    public boolean hasNext() {
        this.updateNext();
        return this.current != null;
    }

    public T next() {
        if (this.hasNext()) {
            T element = this.current;
            this.current = null;
            return element;
        }
        throw new NoSuchElementException();
    }

    private void updateNext() {
        while (this.current == null && this.entryIterator.hasNext()) {
            Map.Entry next = (Map.Entry)this.entryIterator.next();
            T mapped = this.transform(next.getKey(), next.getValue());
            if (mapped != null) {
                ++this.index;
            }
            if (this.index <= this.skip || this.max != -1L && this.index > this.skip + this.max) continue;
            this.current = mapped;
        }
    }

    private T transform(K k, S s) {
        if (s == null) {
            return null;
        }
        if (this.mapper == null) {
            return (T)s;
        }
        return this.mapper.apply(k, s);
    }

    public MappingEntryIterator<K, S, T> skip(long skip) {
        this.skip = skip;
        return this;
    }

    public MappingEntryIterator<K, S, T> limit(long max) {
        this.max = max;
        return this;
    }

    public void close() {
        this.entryIterator.close();
    }
}

