/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

class SlicingCollector<U, A, R>
implements Collector<U, A, R> {
    private final Collector<U, A, R> collector;
    private final long skip;
    private final long limit;
    private long count = 0L;

    public SlicingCollector(Collector<U, A, R> collector, long skip, long limit) {
        this.collector = collector;
        this.skip = skip;
        this.limit = limit < 0L ? -1L : limit;
    }

    long getCount() {
        return this.count;
    }

    @Override
    public Supplier<A> supplier() {
        return this.collector.supplier();
    }

    @Override
    public BiConsumer<A, U> accumulator() {
        BiConsumer<A, U> accumulator = this.collector.accumulator();
        return (a, u) -> {
            ++this.count;
            if (this.count > this.skip && (this.limit == -1L || this.count <= this.skip + this.limit)) {
                accumulator.accept(a, u);
            }
        };
    }

    @Override
    public BinaryOperator<A> combiner() {
        return this.collector.combiner();
    }

    @Override
    public Function<A, R> finisher() {
        return this.collector.finisher();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return this.collector.characteristics();
    }
}

