/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Operation1_2;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInterval;
import org.h2.value.ValueNull;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestampTimeZone;

public final class TimeZoneOperation
extends Operation1_2 {
    public TimeZoneOperation(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder stringBuilder, int n) {
        this.left.getSQL(stringBuilder, n, 0).append(" AT ");
        if (this.right != null) {
            this.right.getSQL(stringBuilder.append("TIME ZONE "), n, 0);
        } else {
            stringBuilder.append("LOCAL");
        }
        return stringBuilder;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        Value value = this.left.getValue(sessionLocal).convertTo(this.type, (CastDataProvider)sessionLocal);
        int n = value.getValueType();
        if ((n == 21 || n == 19) && this.right != null) {
            Value value2 = this.right.getValue(sessionLocal);
            if (value2 != ValueNull.INSTANCE) {
                if (n == 21) {
                    int n2;
                    ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                    long l = valueTimestampTimeZone.getDateValue();
                    long l2 = valueTimestampTimeZone.getTimeNanos();
                    int n3 = valueTimestampTimeZone.getTimeZoneOffsetSeconds();
                    if (n3 != (n2 = TimeZoneOperation.parseTimeZone(value2, l, l2, n3, true))) {
                        value = DateTimeUtils.timestampTimeZoneAtOffset(l, l2, n3, n2);
                    }
                } else {
                    int n4;
                    ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value;
                    long l = valueTimeTimeZone.getNanos();
                    int n5 = valueTimeTimeZone.getTimeZoneOffsetSeconds();
                    if (n5 != (n4 = TimeZoneOperation.parseTimeZone(value2, 1008673L, l, n5, false))) {
                        value = ValueTimeTimeZone.fromNanos(DateTimeUtils.normalizeNanosOfDay(l += (long)(n4 - n5) * 1000000000L), n4);
                    }
                }
            } else {
                value = ValueNull.INSTANCE;
            }
        }
        return value;
    }

    private static int parseTimeZone(Value value, long l, long l2, int n, boolean bl) {
        if (DataType.isCharacterStringType(value.getValueType())) {
            TimeZoneProvider timeZoneProvider;
            try {
                timeZoneProvider = TimeZoneProvider.ofId(value.getString());
            }
            catch (RuntimeException runtimeException) {
                throw DbException.getInvalidValueException("time zone", value.getTraceSQL());
            }
            if (!bl && !timeZoneProvider.hasFixedOffset()) {
                throw DbException.getInvalidValueException("time zone", value.getTraceSQL());
            }
            return timeZoneProvider.getTimeZoneOffsetUTC(DateTimeUtils.getEpochSeconds(l, l2, n));
        }
        return TimeZoneOperation.parseInterval(value);
    }

    public static int parseInterval(Value value) {
        ValueInterval valueInterval = (ValueInterval)value.convertTo(TypeInfo.TYPE_INTERVAL_HOUR_TO_SECOND);
        long l = valueInterval.getLeading();
        long l2 = valueInterval.getRemaining();
        if (l > 18L || l == 18L && l2 != 0L || l2 % 1000000000L != 0L) {
            throw DbException.getInvalidValueException("time zone", valueInterval.getTraceSQL());
        }
        int n = (int)(l * 3600L + l2 / 1000000000L);
        if (valueInterval.isNegative()) {
            n = -n;
        }
        return n;
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        this.left = this.left.optimize(sessionLocal);
        if (this.right != null) {
            this.right = this.right.optimize(sessionLocal);
        }
        TypeInfo typeInfo = this.left.getType();
        int n = 21;
        int n2 = 9;
        switch (typeInfo.getValueType()) {
            case 20: 
            case 21: {
                n2 = typeInfo.getScale();
                break;
            }
            case 18: 
            case 19: {
                n = 19;
                n2 = typeInfo.getScale();
                break;
            }
            default: {
                StringBuilder stringBuilder = this.left.getSQL(new StringBuilder(), 3, 0);
                int n3 = stringBuilder.length();
                stringBuilder.append(" AT ");
                if (this.right != null) {
                    this.right.getSQL(stringBuilder.append("TIME ZONE "), 3, 0);
                } else {
                    stringBuilder.append("LOCAL");
                }
                throw DbException.getSyntaxError(stringBuilder.toString(), n3, "time, timestamp");
            }
        }
        this.type = TypeInfo.getTypeInfo(n, -1L, n2, null);
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return ValueExpression.get(this.getValue(sessionLocal));
        }
        return this;
    }
}

