/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ConfigurationFilePersistenceResource;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.XmlConfigurationPersister;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class BackupXmlConfigurationPersister
extends XmlConfigurationPersister {
    private ConfigurationFile configurationFile;
    private final AtomicBoolean successfulBoot = new AtomicBoolean();

    public BackupXmlConfigurationPersister(ConfigurationFile file, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser, boolean suppressLoad) {
        super(file.getBootFile(), rootElement, rootParser, rootDeparser, suppressLoad);
        this.configurationFile = file;
    }

    public BackupXmlConfigurationPersister(ConfigurationFile file, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser, boolean reload, boolean allowEmpty) {
        super(file.getBootFile(), rootElement, rootParser, rootDeparser, BackupXmlConfigurationPersister.isSuppressLoad(file, reload, allowEmpty));
        this.configurationFile = file;
    }

    private static boolean isSuppressLoad(ConfigurationFile configurationFile, boolean reload, boolean allowEmpty) {
        if (allowEmpty && configurationFile.getBootFile().length() == 0L) {
            return true;
        }
        ConfigurationFile.InteractionPolicy interactionPolicy = configurationFile.getInteractionPolicy();
        boolean initialEmpty = interactionPolicy == ConfigurationFile.InteractionPolicy.NEW || interactionPolicy == ConfigurationFile.InteractionPolicy.DISCARD;
        return initialEmpty && !reload;
    }

    @Override
    public void registerAdditionalRootElement(QName anotherRoot, XMLElementReader<List<ModelNode>> parser) {
        super.registerAdditionalRootElement(anotherRoot, parser);
    }

    @Override
    public void successfulBoot() throws ConfigurationPersistenceException {
        if (this.successfulBoot.compareAndSet(false, true)) {
            this.configurationFile.successfulBoot();
        }
    }

    @Override
    public boolean isPersisting() {
        return this.successfulBoot.get();
    }

    @Override
    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        if (!this.successfulBoot.get()) {
            return new ConfigurationPersister.PersistenceResource(){

                @Override
                public void commit() {
                }

                @Override
                public void rollback() {
                }
            };
        }
        return new ConfigurationFilePersistenceResource(model, this.configurationFile, this);
    }

    @Override
    public String snapshot(String name, String comment) throws ConfigurationPersistenceException {
        return this.configurationFile.snapshot(name, comment);
    }

    @Override
    public ConfigurationPersister.SnapshotInfo listSnapshots() {
        return this.configurationFile.listSnapshots();
    }

    @Override
    public void deleteSnapshot(String name) {
        this.configurationFile.deleteSnapshot(name);
    }
}

