/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.util;

import com.arjuna.webservices.logging.WSCLogger;
import jakarta.xml.ws.Service;
import java.security.PrivilegedAction;

public final class ServiceAction<T extends Service>
implements PrivilegedAction<T> {
    private final Class<T> serviceClass;

    public ServiceAction(Class<T> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public static <T extends Service> ServiceAction<T> getInstance(Class<T> serviceClass) {
        return new ServiceAction<T>(serviceClass);
    }

    @Override
    public T run() {
        try {
            return (T)((Service)this.serviceClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            WSCLogger.i18NLogger.warn_cannot_create_service_instance(this.serviceClass, e);
            throw new RuntimeException(e);
        }
    }
}

