/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import jakarta.persistence.MappedSuperclass;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.envers.Audited;
import org.hibernate.envers.boot.internal.ModifiedColumnNameResolver;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditOverrideData;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.internal.util.StringHelper;

public class ComponentAuditedPropertiesReader
extends AuditedPropertiesReader {
    private final ComponentAuditingData componentAuditingData;

    public ComponentAuditedPropertiesReader(EnversMetadataBuildingContext metadataBuildingContext, PersistentPropertiesSource persistentPropertiesSource, AuditedPropertiesHolder auditedPropertiesHolder) {
        this(metadataBuildingContext, persistentPropertiesSource, auditedPropertiesHolder, "");
    }

    public ComponentAuditedPropertiesReader(EnversMetadataBuildingContext metadataBuildingContext, PersistentPropertiesSource persistentPropertiesSource, AuditedPropertiesHolder auditedPropertiesHolder, String propertyNamePrefix) {
        super(metadataBuildingContext, persistentPropertiesSource, auditedPropertiesHolder, propertyNamePrefix);
        this.componentAuditingData = (ComponentAuditingData)auditedPropertiesHolder;
    }

    @Override
    protected boolean isClassHierarchyTraversalNeeded(Audited allClassAudited) {
        return true;
    }

    @Override
    protected boolean checkAudited(XProperty property, PropertyAuditingData propertyData, String propertyName, Audited allClassAudited, String modifiedFlagSuffix) {
        Audited aud = (Audited)property.getAnnotation(Audited.class);
        if (aud != null) {
            propertyData.setRelationTargetAuditMode(aud.targetAuditMode());
            propertyData.setUsingModifiedFlag(this.checkUsingModifiedFlag(aud));
            propertyData.setModifiedFlagName(ModifiedColumnNameResolver.getName(propertyName, modifiedFlagSuffix));
            if (StringHelper.isNotEmpty((String)aud.modifiedColumnName())) {
                propertyData.setExplicitModifiedFlagName(aud.modifiedColumnName());
            }
        } else {
            XClass declaringClass = property.getDeclaringClass();
            boolean classAuditedOverride = false;
            boolean classNotAuditedOverride = false;
            for (AuditOverrideData auditOverride : this.componentAuditingData.getAuditingOverrides()) {
                if (auditOverride.getForClass() == Void.TYPE) continue;
                String className = auditOverride.getForClass().getName();
                if (!declaringClass.getName().equals(className)) continue;
                if (!auditOverride.isAudited()) {
                    if ("".equals(auditOverride.getName())) {
                        classNotAuditedOverride = true;
                    }
                    if (!property.getName().equals(auditOverride.getName())) continue;
                    return false;
                }
                if ("".equals(auditOverride.getName())) {
                    classAuditedOverride = true;
                }
                if (!property.getName().equals(auditOverride.getName())) continue;
                return true;
            }
            if (classNotAuditedOverride || this.isOverriddenNotAudited(property) || this.isOverriddenNotAudited(declaringClass)) {
                return false;
            }
            if (classAuditedOverride || this.isOverriddenAudited(property) || this.isOverriddenAudited(declaringClass)) {
                return true;
            }
            if (declaringClass.isAnnotationPresent(MappedSuperclass.class)) {
                return false;
            }
        }
        return true;
    }
}

