/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQPropertyConversionException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.jms.client.ConnectionFactoryOptions;
import org.hornetq.jms.client.HornetQBytesMessage;
import org.hornetq.jms.client.HornetQConnection;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQJMSClientBundle;
import org.hornetq.jms.client.HornetQMapMessage;
import org.hornetq.jms.client.HornetQObjectMessage;
import org.hornetq.jms.client.HornetQStreamMessage;
import org.hornetq.jms.client.HornetQTextMessage;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.utils.UUID;

public class HornetQMessage
implements Message {
    private static final SimpleString REPLYTO_HEADER_NAME = ClientMessageImpl.REPLYTO_HEADER_NAME;
    private static final SimpleString CORRELATIONID_HEADER_NAME = new SimpleString("JMSCorrelationID");
    private static final SimpleString TYPE_HEADER_NAME = new SimpleString("JMSType");
    private static final SimpleString JMS = new SimpleString("JMS");
    private static final SimpleString JMSX = new SimpleString("JMSX");
    private static final SimpleString JMS_ = new SimpleString("JMS_");
    private static final String JMSXDELIVERYCOUNT = "JMSXDeliveryCount";
    private static final String JMSXGROUPID = "JMSXGroupID";
    public static final byte TYPE = 0;
    private static final HashSet<String> reservedIdentifiers = new HashSet();
    protected ClientMessage message;
    private ClientSession session;
    protected boolean readOnly;
    protected boolean propertiesReadOnly;
    private Destination dest;
    private String msgID;
    private Destination replyTo;
    private String jmsCorrelationID;
    private String jmsType;
    private boolean individualAck;
    private long jmsDeliveryTime;

    public static Map<String, Object> coreMaptoJMSMap(Map<String, Object> coreMessage) {
        HashMap<String, Object> jmsMessage = new HashMap<String, Object>();
        String deliveryMode = (Boolean)coreMessage.get("durable") != false ? "PERSISTENT" : "NON_PERSISTENT";
        byte priority = (Byte)coreMessage.get("priority");
        long timestamp = (Long)coreMessage.get("timestamp");
        long expiration = (Long)coreMessage.get("expiration");
        jmsMessage.put("JMSPriority", priority);
        jmsMessage.put("JMSTimestamp", timestamp);
        jmsMessage.put("JMSExpiration", expiration);
        jmsMessage.put("JMSDeliveryMode", deliveryMode);
        for (Map.Entry<String, Object> entry : coreMessage.entrySet()) {
            if (entry.getKey().equals("type") || entry.getKey().equals("durable") || entry.getKey().equals("expiration") || entry.getKey().equals("timestamp") || entry.getKey().equals("priority")) continue;
            if (entry.getKey().equals("userID")) {
                jmsMessage.put("JMSMessageID", entry.getValue().toString());
                continue;
            }
            Object value = entry.getValue();
            if (value instanceof SimpleString) {
                jmsMessage.put(entry.getKey(), value.toString());
                continue;
            }
            jmsMessage.put(entry.getKey(), value);
        }
        return jmsMessage;
    }

    public static HornetQMessage createMessage(ClientMessage message, ClientSession session) {
        return HornetQMessage.createMessage(message, session, null);
    }

    public static HornetQMessage createMessage(ClientMessage message, ClientSession session, ConnectionFactoryOptions options) {
        HornetQMessage msg;
        byte type = message.getType();
        switch (type) {
            case 0: {
                msg = new HornetQMessage(message, session);
                break;
            }
            case 4: {
                msg = new HornetQBytesMessage(message, session);
                break;
            }
            case 5: {
                msg = new HornetQMapMessage(message, session);
                break;
            }
            case 2: {
                msg = new HornetQObjectMessage(message, session, options);
                break;
            }
            case 6: {
                msg = new HornetQStreamMessage(message, session);
                break;
            }
            case 3: {
                msg = new HornetQTextMessage(message, session);
                break;
            }
            default: {
                throw new JMSRuntimeException("Invalid message type " + type);
            }
        }
        return msg;
    }

    protected HornetQMessage(byte type, ClientSession session) {
        this.message = session.createMessage(type, true, 0L, System.currentTimeMillis(), (byte)4);
    }

    protected HornetQMessage(ClientSession session) {
        this(0, session);
    }

    public HornetQMessage(ClientMessage message, ClientSession session) {
        this.message = message;
        this.readOnly = true;
        this.propertiesReadOnly = true;
        this.session = session;
    }

    public HornetQMessage(Message foreign, ClientSession session) throws JMSException {
        this(foreign, 0, session);
    }

    public HornetQMessage() {
    }

    protected HornetQMessage(Message foreign, byte type, ClientSession session) throws JMSException {
        this(type, session);
        boolean supportBytesId;
        this.setJMSTimestamp(foreign.getJMSTimestamp());
        String value = System.getProperty("hq.jms.support-bytes-id");
        boolean bl = supportBytesId = !"false".equals(value);
        if (supportBytesId) {
            try {
                byte[] corrIDBytes = foreign.getJMSCorrelationIDAsBytes();
                this.setJMSCorrelationIDAsBytes(corrIDBytes);
            }
            catch (JMSException e) {
                String corrIDString = foreign.getJMSCorrelationID();
                if (corrIDString != null) {
                    this.setJMSCorrelationID(corrIDString);
                }
            }
        } else {
            String corrIDString = foreign.getJMSCorrelationID();
            if (corrIDString != null) {
                this.setJMSCorrelationID(corrIDString);
            }
        }
        this.setJMSReplyTo(foreign.getJMSReplyTo());
        this.setJMSDestination(foreign.getJMSDestination());
        this.setJMSDeliveryMode(foreign.getJMSDeliveryMode());
        this.setJMSExpiration(foreign.getJMSExpiration());
        this.setJMSPriority(foreign.getJMSPriority());
        this.setJMSType(foreign.getJMSType());
        Enumeration props = foreign.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            Object prop = foreign.getObjectProperty(name);
            this.setObjectProperty(name, prop);
        }
    }

    public String getJMSMessageID() {
        if (this.msgID == null) {
            UUID uid = this.message.getUserID();
            this.msgID = uid == null ? null : "ID:" + uid.toString();
        }
        return this.msgID;
    }

    public void setJMSMessageID(String jmsMessageID) throws JMSException {
        if (jmsMessageID != null && !jmsMessageID.startsWith("ID:")) {
            throw new JMSException("JMSMessageID must start with ID:");
        }
        this.message.setUserID(null);
        this.msgID = jmsMessageID;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.message.getTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.message.setTimestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        Object obj = this.message.getObjectProperty(CORRELATIONID_HEADER_NAME);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        if (correlationID == null || correlationID.length == 0) {
            throw new JMSException("Please specify a non-zero length byte[]");
        }
        this.message.putBytesProperty(CORRELATIONID_HEADER_NAME, correlationID);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        if (correlationID == null) {
            this.message.removeProperty(CORRELATIONID_HEADER_NAME);
            this.jmsCorrelationID = null;
        } else {
            this.message.putStringProperty(CORRELATIONID_HEADER_NAME, new SimpleString(correlationID));
            this.jmsCorrelationID = correlationID;
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        if (this.jmsCorrelationID == null) {
            try {
                this.jmsCorrelationID = this.message.getStringProperty(CORRELATIONID_HEADER_NAME);
            }
            catch (HornetQPropertyConversionException e) {
                this.jmsCorrelationID = null;
            }
        }
        return this.jmsCorrelationID;
    }

    public Destination getJMSReplyTo() throws JMSException {
        SimpleString repl;
        if (this.replyTo == null && (repl = this.message.getSimpleStringProperty(REPLYTO_HEADER_NAME)) != null) {
            this.replyTo = HornetQDestination.fromAddress(repl.toString());
        }
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination dest) throws JMSException {
        if (dest == null) {
            this.message.removeProperty(REPLYTO_HEADER_NAME);
            this.replyTo = null;
        } else {
            if (!(dest instanceof HornetQDestination)) {
                throw new InvalidDestinationException("Not a HornetQ destination " + dest);
            }
            HornetQDestination jbd = (HornetQDestination)dest;
            this.message.putStringProperty(REPLYTO_HEADER_NAME, jbd.getSimpleAddress());
            this.replyTo = jbd;
        }
    }

    public Destination getJMSDestination() throws JMSException {
        if (this.dest == null) {
            SimpleString sdest = this.message.getAddress();
            this.dest = sdest == null ? null : HornetQDestination.fromAddress(sdest.toString());
        }
        return this.dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.dest = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.message.isDurable() ? 2 : 1;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode == 2) {
            this.message.setDurable(true);
        } else if (deliveryMode == 1) {
            this.message.setDurable(false);
        } else {
            throw HornetQJMSClientBundle.BUNDLE.illegalDeliveryMode(deliveryMode);
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.message.getDeliveryCount() > 1;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (!redelivered) {
            this.message.setDeliveryCount(1);
        } else if (this.message.getDeliveryCount() <= 1) {
            this.message.setDeliveryCount(2);
        }
    }

    public void setJMSType(String type) throws JMSException {
        if (type != null) {
            this.message.putStringProperty(TYPE_HEADER_NAME, new SimpleString(type));
            this.jmsType = type;
        }
    }

    public String getJMSType() throws JMSException {
        SimpleString ss;
        if (this.jmsType == null && (ss = this.message.getSimpleStringProperty(TYPE_HEADER_NAME)) != null) {
            this.jmsType = ss.toString();
        }
        return this.jmsType;
    }

    public long getJMSExpiration() throws JMSException {
        return this.message.getExpiration();
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.message.setExpiration(expiration);
    }

    public int getJMSPriority() throws JMSException {
        return this.message.getPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.checkPriority(priority);
        this.message.setPriority((byte)priority);
    }

    public void clearProperties() throws JMSException {
        ArrayList<SimpleString> toRemove = new ArrayList<SimpleString>();
        for (SimpleString propName : this.message.getPropertyNames()) {
            if (propName.startsWith(JMS) && !propName.startsWith(JMSX) && !propName.startsWith(JMS_)) continue;
            toRemove.add(propName);
        }
        for (SimpleString propName : toRemove) {
            this.message.removeProperty(propName);
        }
        this.propertiesReadOnly = false;
    }

    public void clearBody() throws JMSException {
        this.readOnly = false;
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.message.containsProperty(new SimpleString(name)) || name.equals(JMSXDELIVERYCOUNT) || JMSXGROUPID.equals(name) && this.message.containsProperty(org.hornetq.api.core.Message.HDR_GROUP_ID);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        try {
            return this.message.getBooleanProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public byte getByteProperty(String name) throws JMSException {
        try {
            return this.message.getByteProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public short getShortProperty(String name) throws JMSException {
        try {
            return this.message.getShortProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public int getIntProperty(String name) throws JMSException {
        if (JMSXDELIVERYCOUNT.equals(name)) {
            return this.message.getDeliveryCount();
        }
        try {
            return this.message.getIntProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public long getLongProperty(String name) throws JMSException {
        if (JMSXDELIVERYCOUNT.equals(name)) {
            return this.message.getDeliveryCount();
        }
        try {
            return this.message.getLongProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public float getFloatProperty(String name) throws JMSException {
        try {
            return this.message.getFloatProperty(new SimpleString(name)).floatValue();
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public double getDoubleProperty(String name) throws JMSException {
        try {
            return this.message.getDoubleProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public String getStringProperty(String name) throws JMSException {
        if (JMSXDELIVERYCOUNT.equals(name)) {
            return String.valueOf(this.message.getDeliveryCount());
        }
        try {
            if (JMSXGROUPID.equals(name)) {
                return this.message.getStringProperty(org.hornetq.api.core.Message.HDR_GROUP_ID);
            }
            return this.message.getStringProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (JMSXDELIVERYCOUNT.equals(name)) {
            return String.valueOf(this.message.getDeliveryCount());
        }
        Object val = this.message.getObjectProperty(name);
        if (val instanceof SimpleString) {
            val = ((SimpleString)val).toString();
        }
        return val;
    }

    public Enumeration getPropertyNames() throws JMSException {
        HashSet<String> set = new HashSet<String>();
        for (SimpleString propName : this.message.getPropertyNames()) {
            if (propName.startsWith(JMS) && !propName.startsWith(JMSX) && !propName.startsWith(JMS_) || propName.startsWith(HornetQConnection.CONNECTION_ID_PROPERTY_NAME)) continue;
            set.add(propName.toString());
        }
        set.add(JMSXDELIVERYCOUNT);
        return Collections.enumeration(set);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkProperty(name);
        this.message.putBooleanProperty(new SimpleString(name), value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkProperty(name);
        this.message.putByteProperty(new SimpleString(name), value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkProperty(name);
        this.message.putShortProperty(new SimpleString(name), value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkProperty(name);
        this.message.putIntProperty(new SimpleString(name), value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.checkProperty(name);
        this.message.putLongProperty(new SimpleString(name), value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkProperty(name);
        this.message.putFloatProperty(new SimpleString(name), value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkProperty(name);
        this.message.putDoubleProperty(new SimpleString(name), value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkProperty(name);
        if (JMSXGROUPID.equals(name)) {
            this.message.putStringProperty(org.hornetq.api.core.Message.HDR_GROUP_ID, SimpleString.toSimpleString((String)value));
        } else {
            this.message.putStringProperty(new SimpleString(name), SimpleString.toSimpleString((String)value));
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if ("JMS_HQ_OutputStream".equals(name)) {
            this.setOutputStream((OutputStream)value);
            return;
        }
        if ("JMS_HQ_SaveStream".equals(name)) {
            this.saveToOutputStream((OutputStream)value);
            return;
        }
        this.checkProperty(name);
        if ("JMS_HQ_InputStream".equals(name)) {
            this.setInputStream((InputStream)value);
            return;
        }
        try {
            this.message.putObjectProperty(new SimpleString(name), value);
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public void acknowledge() throws JMSException {
        if (this.session != null) {
            try {
                if (this.individualAck) {
                    this.message.individualAcknowledge();
                }
                this.session.commit();
            }
            catch (HornetQException e) {
                throw JMSExceptionHelper.convertFromHornetQException(e);
            }
        }
    }

    public long getJMSDeliveryTime() throws JMSException {
        Long value;
        try {
            value = this.message.getLongProperty(org.hornetq.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME);
        }
        catch (Exception e) {
            return 0L;
        }
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.message.putLongProperty(org.hornetq.api.core.Message.HDR_SCHEDULED_DELIVERY_TIME, deliveryTime);
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        if (this.isBodyAssignableTo(c)) {
            return this.getBodyInternal(c);
        }
        throw new MessageFormatException("Body not assignable to " + c);
    }

    protected <T> T getBodyInternal(Class<T> c) throws MessageFormatException {
        InputStream is = ((MessageInternal)this.message).getBodyInputStream();
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public boolean isBodyAssignableTo(Class c) {
        return true;
    }

    protected boolean hasNoBody() {
        return this.message.getBodySize() == 0;
    }

    public void setIndividualAcknowledge() {
        this.individualAck = true;
    }

    public void resetMessageID(String newMsgID) {
        this.msgID = newMsgID;
    }

    public ClientMessage getCoreMessage() {
        return this.message;
    }

    public void doBeforeSend() throws Exception {
        this.message.getBodyBuffer().resetReaderIndex();
    }

    public void checkBuffer() {
        this.message.getBodyBuffer();
    }

    public void doBeforeReceive() throws HornetQException {
        this.message.checkCompletion();
        HornetQBuffer body = this.message.getBodyBuffer();
        if (body != null) {
            body.resetReaderIndex();
        }
    }

    public byte getType() {
        return 0;
    }

    public void setInputStream(InputStream input) throws JMSException {
        this.checkStream();
        if (this.readOnly) {
            throw HornetQJMSClientBundle.BUNDLE.messageNotWritable();
        }
        this.message.setBodyInputStream(input);
    }

    public void setOutputStream(OutputStream output) throws JMSException {
        this.checkStream();
        if (!this.readOnly) {
            throw new IllegalStateException("OutputStream property is only valid on received messages");
        }
        try {
            this.message.setOutputStream(output);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public void saveToOutputStream(OutputStream output) throws JMSException {
        this.checkStream();
        if (!this.readOnly) {
            throw new IllegalStateException("OutputStream property is only valid on received messages");
        }
        try {
            this.message.saveToOutputStream(output);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public boolean waitCompletionOnStream(long timeWait) throws JMSException {
        this.checkStream();
        try {
            return this.message.waitOutputStreamCompletion(timeWait);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("HornetQMessage[");
        sb.append(this.getJMSMessageID());
        sb.append("]:");
        sb.append(this.message.isDurable() ? "PERSISTENT" : "NON-PERSISTENT");
        return sb.toString();
    }

    protected void checkWrite() throws JMSException {
        if (this.readOnly) {
            throw HornetQJMSClientBundle.BUNDLE.messageNotWritable();
        }
    }

    protected void checkRead() throws JMSException {
        if (!this.readOnly) {
            throw HornetQJMSClientBundle.BUNDLE.messageNotReadable();
        }
    }

    private void checkStream() throws JMSException {
        if (this.message.getType() != 4 && this.message.getType() != 6) {
            throw HornetQJMSClientBundle.BUNDLE.onlyValidForByteOrStreamMessages();
        }
    }

    private void checkProperty(String name) throws JMSException {
        if (this.propertiesReadOnly) {
            if (name.equals("JMS_HQ_InputStream")) {
                throw new MessageNotWriteableException("You cannot set the Input Stream on received messages. Did you mean JMS_HQ_OutputStream or JMS_HQ_SaveStream?");
            }
            throw HornetQJMSClientBundle.BUNDLE.messageNotWritable();
        }
        if (name == null) {
            throw HornetQJMSClientBundle.BUNDLE.nullArgumentNotAllowed("property");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("The name of a property must not be an empty String.");
        }
        if (!this.isValidJavaIdentifier(name)) {
            throw HornetQJMSClientBundle.BUNDLE.invalidJavaIdentifier(name);
        }
        if (reservedIdentifiers.contains(name)) {
            throw new JMSRuntimeException("The property name '" + name + "' is reserved due to selector syntax.");
        }
        if (name.startsWith("JMS_HORNETQ")) {
            throw new JMSRuntimeException("The property name '" + name + "' is illegal since it starts with JMS_HORNETQ");
        }
    }

    private boolean isValidJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    private void checkPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new JMSException(priority + " is not valid: priority must be between 0 and 9");
        }
    }

    static {
        reservedIdentifiers.add("NULL");
        reservedIdentifiers.add("TRUE");
        reservedIdentifiers.add("FALSE");
        reservedIdentifiers.add("NOT");
        reservedIdentifiers.add("AND");
        reservedIdentifiers.add("OR");
        reservedIdentifiers.add("BETWEEN");
        reservedIdentifiers.add("LIKE");
        reservedIdentifiers.add("IN");
        reservedIdentifiers.add("IS");
        reservedIdentifiers.add("ESCAPE");
    }
}

