/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.Ejb2xViewType;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulTransactionMarker;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBean;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class StatefulRemoveInterceptor
implements Interceptor {
    private final boolean retainIfException;

    public StatefulRemoveInterceptor(boolean retainIfException) {
        this.retainIfException = retainIfException;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulTransactionMarker marker;
        Ejb2xViewType viewType;
        EJBComponent component = (EJBComponent)((Object)context.getPrivateData(Component.class));
        ComponentView view = (ComponentView)context.getPrivateData(ComponentView.class);
        if (view != null && (viewType = (Ejb2xViewType)((Object)view.getPrivateData(Ejb2xViewType.class))) != null && (marker = (StatefulTransactionMarker)context.getPrivateData(StatefulTransactionMarker.class)) != null && !marker.isFirstInvocation()) {
            throw EjbLogger.ROOT_LOGGER.cannotRemoveWhileParticipatingInTransaction();
        }
        if (!(component instanceof StatefulSessionComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent((Component)component, StatefulSessionComponent.class);
        }
        Object invocationResult = null;
        try {
            invocationResult = context.proceed();
        }
        catch (Exception e) {
            if (StatefulRemoveInterceptor.isApplicationException(component, e.getClass(), context.getMethod()) && this.retainIfException) {
                throw e;
            }
            StatefulRemoveInterceptor.remove(context);
            throw e;
        }
        StatefulRemoveInterceptor.remove(context);
        return invocationResult;
    }

    private static void remove(InterceptorContext context) {
        StatefulSessionBean<SessionID, StatefulSessionComponentInstance> bean = StatefulComponentInstanceInterceptor.getBean(context);
        if (bean.isClosed()) {
            StatefulSessionComponent component = (StatefulSessionComponent)context.getPrivateData(Component.class);
            SessionID id = (SessionID)context.getPrivateData(SessionID.class);
            bean = component.getCache().findStatefulSessionBean(id);
        }
        if (bean != null) {
            bean.remove();
        }
    }

    private static boolean isApplicationException(EJBComponent ejbComponent, Class<?> exceptionClass, Method invokedMethod) {
        return ejbComponent.getApplicationException(exceptionClass, invokedMethod) != null;
    }
}

