/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful.cache.distributable;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheConfiguration;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheFactory;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstanceFactory;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBeanCacheConfiguration;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ejb.bean.BeanExpirationConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManager;
import org.wildfly.clustering.ejb.bean.BeanManagerConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManagerFactory;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class DistributableStatefulSessionBeanCacheFactoryServiceConfigurator<K, V extends StatefulSessionBeanInstance<K>>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
StatefulSessionBeanCacheFactory<K, V> {
    private final CapabilityServiceConfigurator configurator;
    private final SupplierDependency<BeanManagerFactory<K, V, Batch>> factory;

    public DistributableStatefulSessionBeanCacheFactoryServiceConfigurator(ServiceName name, CapabilityServiceConfigurator configurator) {
        super(name);
        this.configurator = configurator;
        this.factory = new ServiceSupplierDependency((ServiceNameProvider)configurator);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.configurator.configure(support);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.configurator.build(target).install();
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer factory = new CompositeDependency(new Dependency[]{this.factory}).register(builder).provides(new ServiceName[]{name});
        Service service = Service.newInstance((Consumer)factory, (Object)this);
        return builder.setInstance(service);
    }

    @Override
    public StatefulSessionBeanCache<K, V> createStatefulBeanCache(final StatefulSessionBeanCacheConfiguration<K, V> configuration) {
        final Duration timeout = configuration.getTimeout();
        final Consumer<StatefulSessionBeanInstance> timeoutListener = StatefulSessionBeanInstance::removed;
        final BeanExpirationConfiguration expiration = timeout != null ? new BeanExpirationConfiguration<K, V>(){

            public Duration getTimeout() {
                return timeout;
            }

            public Consumer<V> getExpirationListener() {
                return timeoutListener;
            }
        } : null;
        final BeanManager manager = ((BeanManagerFactory)this.factory.get()).createBeanManager(new BeanManagerConfiguration<K, V>(){

            public Supplier<K> getIdentifierFactory() {
                return configuration.getIdentifierFactory();
            }

            public String getBeanName() {
                return configuration.getComponentName();
            }

            public BeanExpirationConfiguration<K, V> getExpiration() {
                return expiration;
            }
        });
        return new DistributableStatefulSessionBeanCache(new DistributableStatefulSessionBeanCacheConfiguration<K, V>(){

            @Override
            public StatefulSessionBeanInstanceFactory<V> getInstanceFactory() {
                return configuration.getInstanceFactory();
            }

            @Override
            public Supplier<K> getIdentifierFactory() {
                return manager.getIdentifierFactory();
            }

            @Override
            public BeanManager<K, V, Batch> getBeanManager() {
                return manager;
            }

            @Override
            public Duration getTimeout() {
                return timeout;
            }

            @Override
            public String getComponentName() {
                return configuration.getComponentName();
            }
        });
    }
}

