/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful.cache.simple;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheConfiguration;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheFactory;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstanceFactory;
import org.jboss.as.ejb3.component.stateful.cache.simple.SimpleStatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.simple.SimpleStatefulSessionBeanCacheConfiguration;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class SimpleStatefulSessionBeanCacheFactoryServiceConfigurator<K, V extends StatefulSessionBeanInstance<K>>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
StatefulSessionBeanCacheFactory<K, V> {
    private final SupplierDependency<ServerEnvironment> environment = new ServiceSupplierDependency(ServerEnvironmentService.SERVICE_NAME);

    public SimpleStatefulSessionBeanCacheFactoryServiceConfigurator(StatefulComponentDescription description) {
        super(description.getCacheFactoryServiceName());
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer factory = this.environment.register(builder).provides(new ServiceName[]{name});
        Service service = Service.newInstance((Consumer)factory, (Object)this);
        return builder.setInstance(service);
    }

    @Override
    public StatefulSessionBeanCache<K, V> createStatefulBeanCache(final StatefulSessionBeanCacheConfiguration<K, V> configuration) {
        final ServerEnvironment environment = (ServerEnvironment)this.environment.get();
        return new SimpleStatefulSessionBeanCache(new SimpleStatefulSessionBeanCacheConfiguration<K, V>(){

            @Override
            public StatefulSessionBeanInstanceFactory<V> getInstanceFactory() {
                return configuration.getInstanceFactory();
            }

            @Override
            public Supplier<K> getIdentifierFactory() {
                return configuration.getIdentifierFactory();
            }

            @Override
            public Duration getTimeout() {
                return configuration.getTimeout();
            }

            @Override
            public ServerEnvironment getEnvironment() {
                return environment;
            }

            @Override
            public String getComponentName() {
                return configuration.getComponentName();
            }
        });
    }
}

