/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.health;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.health.HealthSubsystemDefinition;
import org.wildfly.extension.health.HealthSubsystemSchema;

public class HealthExtension
implements Extension {
    static final String EXTENSION_NAME = "org.wildfly.extension.health";
    public static final String SUBSYSTEM_NAME = "health";
    protected static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"health");
    protected static final ModelVersion VERSION_1_0_0;
    private static final ModelVersion CURRENT_MODEL_VERSION;
    static final ParentResourceDescriptionResolver SUBSYSTEM_RESOLVER;
    private final PersistentResourceXMLDescription currentDescription = HealthSubsystemSchema.CURRENT.getXMLDescription();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        subsystem.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter(this.currentDescription));
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new HealthSubsystemDefinition());
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (HealthSubsystemSchema schema : EnumSet.allOf(HealthSubsystemSchema.class)) {
            HealthSubsystemSchema reader = schema == HealthSubsystemSchema.CURRENT ? new PersistentResourceXMLDescriptionReader(this.currentDescription) : schema;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespace().getUri(), (XMLElementReader)reader);
        }
    }

    static {
        CURRENT_MODEL_VERSION = VERSION_1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
        SUBSYSTEM_RESOLVER = new SubsystemResourceDescriptionResolver(SUBSYSTEM_NAME, HealthExtension.class);
    }
}

