/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.httpclient.impl.ThreadLocalClientTLSCredentialHandler;
import org.opensaml.security.httpclient.impl.ThreadLocalServerTLSHandler;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.TrustedNamesCriterion;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509CredentialContext;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509TrustEngineContext;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509TrustEngineSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityEnhancedTLSSocketFactory
implements LayeredConnectionSocketFactory {
    private static final ThreadLocalServerTLSHandler SERVER_TLS_HANDLER = new ThreadLocalServerTLSHandler();
    private static final ThreadLocalClientTLSCredentialHandler CLIENT_TLS_HANDLER = new ThreadLocalClientTLSCredentialHandler();
    private final Logger log = LoggerFactory.getLogger(SecurityEnhancedTLSSocketFactory.class);
    @Nonnull
    private LayeredConnectionSocketFactory wrappedFactory;

    public SecurityEnhancedTLSSocketFactory(@Nonnull LayeredConnectionSocketFactory factory) {
        this.wrappedFactory = (LayeredConnectionSocketFactory)Constraint.isNotNull((Object)factory, (String)"Socket factory was null");
    }

    public Socket createSocket(HttpContext context) throws IOException {
        this.log.trace("In createSocket");
        return this.wrappedFactory.createSocket(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        this.log.trace("In connectSocket");
        try {
            this.setup(context, host.getHostName());
            Socket socket = this.wrappedFactory.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
            this.checkAndEvaluateServerTLS(socket);
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            this.teardown(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        this.log.trace("In createLayeredSocket");
        try {
            this.setup(context, target);
            Socket layeredSocket = this.wrappedFactory.createLayeredSocket(socket, target, port, context);
            this.checkAndEvaluateServerTLS(socket);
            Socket socket2 = layeredSocket;
            return socket2;
        }
        finally {
            this.teardown(context);
        }
    }

    protected void checkAndEvaluateServerTLS(@Nonnull Socket socket) throws IOException {
        if (!SSLSocket.class.isInstance(socket)) {
            return;
        }
        if (ThreadLocalX509TrustEngineContext.getTrustEngine() != null) {
            if (ThreadLocalX509TrustEngineContext.getTrusted() == null) {
                this.log.trace("Have TrustEngine but was not previously evaluated, likely due to TLS session resumption. Evaluating now.");
                ThreadLocalX509TrustEngineSupport.evaluate((SSLSocket)SSLSocket.class.cast(socket));
            } else {
                this.log.trace("Had TrustEngine and was previously evaluated as trusted={}", (Object)ThreadLocalX509TrustEngineContext.getTrusted());
            }
        }
    }

    protected void setup(@Nullable HttpContext context, @Nonnull String hostname) throws SSLPeerUnverifiedException {
        this.log.trace("Attempting to setup thread-local data for TLS evaluation");
        if (context == null) {
            this.log.trace("HttpContext was null, skipping thread-local setup");
            return;
        }
        this.setupServerTLS(context, hostname);
        this.setupClientTLS(context);
    }

    protected void setupClientTLS(@Nonnull HttpContext context) {
        X509Credential credential = (X509Credential)context.getAttribute("opensaml.ClientTLSCredential");
        if (credential != null) {
            this.log.trace("Loading ThreadLocalX509CredentialContext with client TLS credential: {}", (Object)credential);
            if (ThreadLocalX509CredentialContext.haveCurrent()) {
                this.log.trace("ThreadLocalX509CredentialContext was already loaded with client TLS credential, will be overwritten with data from HttpContext");
            }
            ThreadLocalX509CredentialContext.loadCurrent(credential);
        } else {
            this.log.trace("X509Credential not supplied by caller, skipping ThreadLocalX509CredentialContext population");
        }
    }

    protected void setupServerTLS(@Nonnull HttpContext context, @Nonnull String hostname) {
        TrustEngine trustEngine = (TrustEngine)context.getAttribute("opensaml.TrustEngine");
        if (trustEngine != null) {
            CriteriaSet criteriaSet = (CriteriaSet)context.getAttribute("opensaml.CriteriaSet");
            if (criteriaSet == null) {
                this.log.debug("No CriteriaSet supplied by caller, building new instance with signing and trusted names criteria");
                criteriaSet = new CriteriaSet(new Criterion[]{new UsageCriterion(UsageType.SIGNING)});
                criteriaSet.add((Object)new TrustedNamesCriterion(Collections.singleton(hostname)));
            } else {
                this.log.trace("Saw CriteriaSet: {}", (Object)criteriaSet);
            }
            Boolean isFailureFatal = (Boolean)context.getAttribute("opensaml.ServerTLSFailureIsFatal");
            if (ThreadLocalX509TrustEngineContext.haveCurrent()) {
                this.log.trace("ThreadLocalX509TrustEngineContext was already loaded with trust engine and criteria, will be overwritten with data from HttpContext");
            }
            ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine<? super X509Credential>)trustEngine, criteriaSet, isFailureFatal);
        } else {
            this.log.debug("TrustEngine not supplied by the caller, skipping ThreadLocalX509TrustEngineContext population");
        }
    }

    protected void teardown(@Nullable HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        if (ThreadLocalX509TrustEngineContext.haveCurrent()) {
            this.log.trace("Scheduling deferred clearing of thread-local server TLS TrustEngine and CriteriaSet");
            HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)clientContext, (HttpClientContextHandler)SERVER_TLS_HANDLER, (boolean)true);
        }
        if (ThreadLocalX509CredentialContext.haveCurrent()) {
            this.log.trace("Scheduling deferred clearing of thread-local client TLS X509Credential");
            HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)clientContext, (HttpClientContextHandler)CLIENT_TLS_HANDLER, (boolean)true);
        }
    }
}

