/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class DescribeConsumerGroupsHandler
extends AdminApiHandler.Batched<CoordinatorKey, ConsumerGroupDescription> {
    private final boolean includeAuthorizedOperations;
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;

    public DescribeConsumerGroupsHandler(boolean includeAuthorizedOperations, LogContext logContext) {
        this.includeAuthorizedOperations = includeAuthorizedOperations;
        this.log = logContext.logger(DescribeConsumerGroupsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    private static Set<CoordinatorKey> buildKeySet(Collection<String> groupIds) {
        return groupIds.stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet());
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, ConsumerGroupDescription> newFuture(Collection<String> groupIds) {
        return AdminApiFuture.forKeys(DescribeConsumerGroupsHandler.buildKeySet(groupIds));
    }

    @Override
    public String apiName() {
        return "describeGroups";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    public DescribeGroupsRequest.Builder buildBatchedRequest(int coordinatorId, Set<CoordinatorKey> keys) {
        List<String> groupIds = keys.stream().map(key -> {
            if (key.type != FindCoordinatorRequest.CoordinatorType.GROUP) {
                throw new IllegalArgumentException("Invalid transaction coordinator key " + key + " when building `DescribeGroups` request");
            }
            return key.idValue;
        }).collect(Collectors.toList());
        DescribeGroupsRequestData data = new DescribeGroupsRequestData().setGroups(groupIds).setIncludeAuthorizedOperations(this.includeAuthorizedOperations);
        return new DescribeGroupsRequest.Builder(data);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        DescribeGroupsResponse response = (DescribeGroupsResponse)abstractResponse;
        HashMap<CoordinatorKey, ConsumerGroupDescription> completed = new HashMap<CoordinatorKey, ConsumerGroupDescription>();
        HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
        HashSet<CoordinatorKey> groupsToUnmap = new HashSet<CoordinatorKey>();
        for (DescribeGroupsResponseData.DescribedGroup describedGroup : response.data().groups()) {
            CoordinatorKey groupIdKey = CoordinatorKey.byGroupId(describedGroup.groupId());
            Errors error = Errors.forCode(describedGroup.errorCode());
            if (error != Errors.NONE) {
                this.handleError(groupIdKey, error, failed, groupsToUnmap);
                continue;
            }
            String protocolType = describedGroup.protocolType();
            if (protocolType.equals("consumer") || protocolType.isEmpty()) {
                List<DescribeGroupsResponseData.DescribedGroupMember> members = describedGroup.members();
                ArrayList<MemberDescription> memberDescriptions = new ArrayList<MemberDescription>(members.size());
                Set<AclOperation> authorizedOperations = this.validAclOperations(describedGroup.authorizedOperations());
                for (DescribeGroupsResponseData.DescribedGroupMember groupMember : members) {
                    Set<TopicPartition> partitions = Collections.emptySet();
                    if (groupMember.memberAssignment().length > 0) {
                        ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment(ByteBuffer.wrap(groupMember.memberAssignment()));
                        partitions = new HashSet<TopicPartition>(assignment.partitions());
                    }
                    memberDescriptions.add(new MemberDescription(groupMember.memberId(), Optional.ofNullable(groupMember.groupInstanceId()), groupMember.clientId(), groupMember.clientHost(), new MemberAssignment(partitions)));
                }
                ConsumerGroupDescription consumerGroupDescription = new ConsumerGroupDescription(groupIdKey.idValue, protocolType.isEmpty(), memberDescriptions, describedGroup.protocolData(), ConsumerGroupState.parse(describedGroup.groupState()), coordinator, authorizedOperations);
                completed.put(groupIdKey, consumerGroupDescription);
                continue;
            }
            failed.put(groupIdKey, new IllegalArgumentException(String.format("GroupId %s is not a consumer group (%s).", groupIdKey.idValue, protocolType)));
        }
        return new AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription>(completed, failed, new ArrayList(groupsToUnmap));
    }

    private void handleError(CoordinatorKey groupId, Errors error, Map<CoordinatorKey, Throwable> failed, Set<CoordinatorKey> groupsToUnmap) {
        switch (error) {
            case GROUP_AUTHORIZATION_FAILED: {
                this.log.debug("`DescribeGroups` request for group id {} failed due to error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("`DescribeGroups` request for group id {} failed because the coordinator is still in the process of loading state. Will retry", (Object)groupId.idValue);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("`DescribeGroups` request for group id {} returned error {}. Will attempt to find the coordinator again and retry", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            default: {
                this.log.error("`DescribeGroups` request for group id {} failed due to unexpected error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
            }
        }
    }

    private Set<AclOperation> validAclOperations(int authorizedOperations) {
        if (authorizedOperations == Integer.MIN_VALUE) {
            return null;
        }
        return Utils.from32BitField(authorizedOperations).stream().map(AclOperation::fromCode).filter(operation -> operation != AclOperation.UNKNOWN && operation != AclOperation.ALL && operation != AclOperation.ANY).collect(Collectors.toSet());
    }
}

