/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.protocol.MessageUtil;

public class ConsumerProtocolAssignmentJsonConverter {
    public static ConsumerProtocolAssignment read(JsonNode _node, short _version) {
        ConsumerProtocolAssignment.TopicPartitionCollection _collection;
        ConsumerProtocolAssignment _object = new ConsumerProtocolAssignment();
        JsonNode _assignedPartitionsNode = _node.get("assignedPartitions");
        if (_assignedPartitionsNode == null) {
            throw new RuntimeException("ConsumerProtocolAssignment: unable to locate field 'assignedPartitions', which is mandatory in version " + _version);
        }
        if (!_assignedPartitionsNode.isArray()) {
            throw new RuntimeException("ConsumerProtocolAssignment expected a JSON array, but got " + _node.getNodeType());
        }
        _object.assignedPartitions = _collection = new ConsumerProtocolAssignment.TopicPartitionCollection(_assignedPartitionsNode.size());
        for (JsonNode _element : _assignedPartitionsNode) {
            _collection.add(TopicPartitionJsonConverter.read(_element, _version));
        }
        JsonNode _userDataNode = _node.get("userData");
        if (_userDataNode == null) {
            throw new RuntimeException("ConsumerProtocolAssignment: unable to locate field 'userData', which is mandatory in version " + _version);
        }
        _object.userData = _userDataNode.isNull() ? null : ByteBuffer.wrap(MessageUtil.jsonNodeToBinary(_userDataNode, "ConsumerProtocolAssignment"));
        return _object;
    }

    public static JsonNode write(ConsumerProtocolAssignment _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _assignedPartitionsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ConsumerProtocolAssignment.TopicPartition _element : _object.assignedPartitions) {
            _assignedPartitionsArray.add(TopicPartitionJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("assignedPartitions", (JsonNode)_assignedPartitionsArray);
        if (_object.userData == null) {
            _node.set("userData", (JsonNode)NullNode.instance);
        } else {
            _node.set("userData", (JsonNode)new BinaryNode(MessageUtil.byteBufferToArray(_object.userData)));
        }
        return _node;
    }

    public static JsonNode write(ConsumerProtocolAssignment _object, short _version) {
        return ConsumerProtocolAssignmentJsonConverter.write(_object, _version, true);
    }

    public static class TopicPartitionJsonConverter {
        public static ConsumerProtocolAssignment.TopicPartition read(JsonNode _node, short _version) {
            ConsumerProtocolAssignment.TopicPartition _object = new ConsumerProtocolAssignment.TopicPartition();
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("TopicPartition: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("TopicPartition expected a string type, but got " + _node.getNodeType());
            }
            _object.topic = _topicNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicPartition: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicPartition expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "TopicPartition element"));
            }
            return _object;
        }

        public static JsonNode write(ConsumerProtocolAssignment.TopicPartition _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.partitions) {
                _partitionsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(ConsumerProtocolAssignment.TopicPartition _object, short _version) {
            return TopicPartitionJsonConverter.write(_object, _version, true);
        }
    }
}

