/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.service.ServiceMBean;
import org.apache.cxf.ws.security.sts.provider.STSException;

public class StaticService
implements ServiceMBean {
    private static final Logger LOG = LogUtils.getL7dLogger(StaticService.class);
    private static final int DEFAULT_MAX_ADDRESS_LENGTH = 8000;
    private String tokenType;
    private String keyType;
    private EncryptionProperties encryptionProperties;
    private int maxAddressLength = 8000;
    private final Collection<Pattern> endpointPatterns = new ArrayList<Pattern>();

    @Override
    public boolean isAddressInEndpoints(String address) {
        String addressToMatch = address;
        if (addressToMatch == null) {
            addressToMatch = "";
        }
        if (addressToMatch.length() > this.maxAddressLength) {
            throw new STSException("The address length exceeds the maximum allowable length");
        }
        for (Pattern endpointPattern : this.endpointPatterns) {
            Matcher matcher = endpointPattern.matcher(addressToMatch);
            if (!matcher.matches()) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Address " + address + " matches with pattern " + endpointPattern);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Setting Token Type: " + tokenType);
        }
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public void setKeyType(String keyType) {
        this.keyType = keyType;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Setting Key Type: " + keyType);
        }
    }

    @Override
    public void setEndpoints(List<String> endpoints) {
        this.endpointPatterns.clear();
        if (endpoints != null) {
            for (String endpoint : endpoints) {
                try {
                    this.endpointPatterns.add(Pattern.compile(endpoint.trim()));
                }
                catch (PatternSyntaxException ex) {
                    LOG.severe(ex.getMessage());
                    throw ex;
                }
            }
        }
    }

    @Override
    public EncryptionProperties getEncryptionProperties() {
        return this.encryptionProperties;
    }

    @Override
    public void setEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        LOG.fine("Setting encryption properties");
    }

    public int getMaxAddressLength() {
        return this.maxAddressLength;
    }

    public void setMaxAddressLength(int maxAddressLength) {
        this.maxAddressLength = maxAddressLength;
    }
}

