/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import jakarta.persistence.EntityManager;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EntityManagerUnwrappedTargetInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 5254527687L;
    private Class<?> wrappedClass;
    private EntityManager targetEntityManager;

    public EntityManagerUnwrappedTargetInvocationHandler() {
    }

    public EntityManagerUnwrappedTargetInvocationHandler(EntityManager targetEntityManager, Class<?> wrappedClass) {
        this.targetEntityManager = targetEntityManager;
        this.wrappedClass = wrappedClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("close".equals(method.getName())) {
            throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
        }
        try {
            return method.invoke(this.getWrappedObject(), args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw e;
        }
    }

    private Object getWrappedObject() {
        return this.targetEntityManager.unwrap(this.wrappedClass);
    }
}

