/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.HasProtoSchema;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;

public final class ProtoEnumValueMetadata
implements HasProtoSchema {
    private final int number;
    private final String protoName;
    private final int javaEnumOrdinal;
    private final String javaEnumName;
    private final String documentation;

    ProtoEnumValueMetadata(int number, String protoName, int javaEnumOrdinal, String javaEnumName, String documentation) {
        this.number = number;
        this.protoName = protoName;
        this.javaEnumOrdinal = javaEnumOrdinal;
        this.javaEnumName = javaEnumName;
        this.documentation = documentation;
    }

    public int getNumber() {
        return this.number;
    }

    public String getProtoName() {
        return this.protoName;
    }

    public int getJavaEnumOrdinal() {
        return this.javaEnumOrdinal;
    }

    public String getJavaEnumName() {
        return this.javaEnumName;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public void generateProto(IndentWriter iw) {
        iw.append("\n");
        ProtoTypeMetadata.appendDocumentation(iw, this.documentation);
        iw.append(this.protoName).append(" = ").append(String.valueOf(this.number));
        if (BaseProtoSchemaGenerator.generateSchemaDebugComments) {
            iw.append(" /* ").append(this.javaEnumName).append(" */");
        }
        iw.append(";\n");
    }

    public String toString() {
        return "ProtoEnumValueMetadata{number=" + this.number + ", protoName='" + this.protoName + "', javaEnumOrdinal=" + this.javaEnumOrdinal + ", javaEnumName='" + this.javaEnumName + "', documentation='" + this.documentation + "'}";
    }
}

