/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.iteration;

import com.ibm.asyncutil.iteration.AsyncIterator;
import com.ibm.asyncutil.iteration.AsyncTrampoline;
import com.ibm.asyncutil.locks.FairAsyncLock;
import com.ibm.asyncutil.util.Combinators;
import com.ibm.asyncutil.util.Either;
import com.ibm.asyncutil.util.StageSupport;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

class AsyncIterators {
    static final EmptyAsyncIterator<?> EMPTY_ITERATOR = new EmptyAsyncIterator();

    private AsyncIterators() {
    }

    static <A, R> R finishContainer(A accumulator, Collector<?, A, R> collector) {
        return (R)(collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? accumulator : collector.finisher().apply(accumulator));
    }

    static <T> void listen(CompletionStage<T> source, CompletableFuture<T> dest) {
        source.whenComplete((t, ex) -> {
            if (ex != null) {
                dest.completeExceptionally((Throwable)ex);
            } else {
                dest.complete(t);
            }
        });
    }

    static <T> CompletionStage<T> convertSynchronousException(Supplier<? extends CompletionStage<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            return StageSupport.exceptionalStage(e);
        }
    }

    static <T, U, V> Either<AsyncIterator.End, V> zipWith(Either<AsyncIterator.End, T> et, Either<AsyncIterator.End, U> eu, BiFunction<? super T, ? super U, V> f) {
        return et.fold(end -> AsyncIterator.End.end(), t -> eu.fold(end -> AsyncIterator.End.end(), u -> Either.right(f.apply(t, u))));
    }

    static <T, U> AsyncIterator<U> thenApplyImpl(final AsyncIterator<T> it, final Function<? super T, ? extends U> f, final boolean synchronous, final Executor e) {
        assert (!synchronous || e == null);
        return new AsyncIterator<U>(){

            @Override
            public CompletionStage<Either<AsyncIterator.End, U>> nextStage() {
                CompletionStage<Either<AsyncIterator.End, Either>> next = it.nextStage();
                return synchronous ? next.thenApply(this::eitherFunction) : (e == null ? next.thenApplyAsync(this::eitherFunction) : next.thenApplyAsync(this::eitherFunction, e));
            }

            Either<AsyncIterator.End, U> eitherFunction(Either<AsyncIterator.End, T> either) {
                return either.map(f);
            }

            @Override
            public CompletionStage<Void> close() {
                return it.close();
            }
        };
    }

    static <T, U> AsyncIterator<U> thenComposeImpl(final AsyncIterator<T> it, final Function<? super T, ? extends CompletionStage<U>> f, final boolean synchronous, final Executor e) {
        assert (!synchronous || e == null);
        return new AsyncIterator<U>(){

            @Override
            public CompletionStage<Either<AsyncIterator.End, U>> nextStage() {
                CompletionStage<Either<AsyncIterator.End, Either>> nxt = it.nextStage();
                return synchronous ? nxt.thenCompose(this::eitherFunction) : (e == null ? nxt.thenComposeAsync(this::eitherFunction) : nxt.thenComposeAsync(this::eitherFunction, e));
            }

            private CompletionStage<Either<AsyncIterator.End, U>> eitherFunction(Either<AsyncIterator.End, T> either) {
                return either.fold(end -> AsyncIterator.End.endStage(), (? super R t) -> ((CompletionStage)f.apply(t)).thenApply(Either::right));
            }

            @Override
            public CompletionStage<Void> close() {
                return it.close();
            }
        };
    }

    static <T> AsyncIterator<T> errorOnce(Throwable ex) {
        return new FailOnceAsyncIterator(ex);
    }

    static <T> CompletionStage<T> asyncWhileAsyncInitial(Predicate<T> shouldContinue, Function<T, CompletionStage<T>> loopBody, CompletionStage<T> initialValue) {
        return initialValue.thenCompose(t -> AsyncTrampoline.asyncWhile(shouldContinue, loopBody, t));
    }

    static class ConcatAsyncIterator<T>
    implements AsyncIterator<T> {
        private final Iterator<? extends AsyncIterator<T>> asyncIterators;
        private AsyncIterator<T> current;

        public ConcatAsyncIterator(Iterator<? extends AsyncIterator<T>> asyncIterators) {
            assert (asyncIterators.hasNext());
            this.asyncIterators = asyncIterators;
            this.current = asyncIterators.next();
        }

        @Override
        public CompletionStage<Either<AsyncIterator.End, T>> nextStage() {
            return AsyncIterators.asyncWhileAsyncInitial(et -> !et.isRight() && this.asyncIterators.hasNext(), ot -> StageSupport.thenComposeOrRecover(AsyncIterators.convertSynchronousException(this.current::close), (t, throwable) -> {
                this.current = throwable == null ? this.asyncIterators.next() : AsyncIterators.errorOnce(throwable);
                return this.current.nextStage();
            }), this.current.nextStage());
        }

        @Override
        public CompletionStage<Void> close() {
            return this.current.close();
        }

        public String toString() {
            return "ConcatAsyncIter [current=" + this.current + ", iter=" + this.asyncIterators + "]";
        }
    }

    private static class FailOnceAsyncIterator<T>
    implements AsyncIterator<T> {
        private Throwable exception;

        FailOnceAsyncIterator(Throwable e) {
            this.exception = Objects.requireNonNull(e);
        }

        @Override
        public CompletionStage<Either<AsyncIterator.End, T>> nextStage() {
            if (this.exception != null) {
                Throwable e = this.exception;
                this.exception = null;
                return StageSupport.exceptionalStage(e);
            }
            return AsyncIterator.End.endStage();
        }
    }

    static class PartiallyEagerAsyncIterator<T, U>
    implements AsyncIterator<U> {
        private final AsyncIterator<T> backingIterator;
        private final int executeAhead;
        private final Function<U, CompletionStage<Void>> closeFn;
        private final Function<Either<AsyncIterator.End, T>, CompletionStage<Either<AsyncIterator.End, U>>> mappingFn;
        private final Queue<CompletionStage<Either<AsyncIterator.End, U>>> pendingResults;
        private final FairAsyncLock lock;
        private boolean closed;

        PartiallyEagerAsyncIterator(AsyncIterator<T> backingIterator, int executeAhead, Function<Either<AsyncIterator.End, T>, CompletionStage<Either<AsyncIterator.End, U>>> mappingFn, Function<U, CompletionStage<Void>> closeFn) {
            this.backingIterator = backingIterator;
            this.executeAhead = executeAhead;
            this.closeFn = closeFn == null ? u -> StageSupport.voidStage() : u -> AsyncIterators.convertSynchronousException(() -> (CompletionStage)closeFn.apply(u));
            this.mappingFn = mappingFn;
            this.pendingResults = new ArrayDeque<CompletionStage<Either<AsyncIterator.End, U>>>(executeAhead);
            this.lock = new FairAsyncLock();
            this.closed = false;
        }

        private CompletionStage<Either<AsyncIterator.End, T>> fillMore() {
            if (this.pendingResults.size() >= this.executeAhead) {
                return AsyncIterator.End.endStage();
            }
            CompletionStage<Either<AsyncIterator.End, Either<AsyncIterator.End, T>>> nxt = AsyncIterators.convertSynchronousException(this.backingIterator::nextStage);
            this.pendingResults.add(nxt.thenCompose(this.mappingFn));
            return nxt;
        }

        private CompletionStage<Void> attachListener(CompletableFuture<Either<AsyncIterator.End, U>> listener) {
            return StageSupport.tryComposeWith(this.lock.acquireLock(), token -> {
                if (this.closed) {
                    IllegalStateException ex = new IllegalStateException("nextStage called after async iterator was closed");
                    listener.completeExceptionally(ex);
                    throw ex;
                }
                CompletionStage<Either<AsyncIterator.End, U>> poll = this.pendingResults.poll();
                if (poll == null) {
                    CompletionStage<Either<AsyncIterator.End, T>> nxt = AsyncIterators.convertSynchronousException(this.backingIterator::nextStage);
                    AsyncIterators.listen(nxt.thenCompose(this.mappingFn), listener);
                    return StageSupport.voided(nxt);
                }
                AsyncIterators.listen(poll, listener);
                return StageSupport.voidStage();
            });
        }

        @Override
        public CompletionStage<Either<AsyncIterator.End, U>> nextStage() {
            CompletableFuture<Either<AsyncIterator.End, U>> listener = new CompletableFuture<Either<AsyncIterator.End, U>>();
            CompletionStage<Void> nextFinished = this.attachListener(listener);
            nextFinished.thenRun(() -> AsyncTrampoline.asyncWhile(() -> StageSupport.tryComposeWith(this.lock.acquireLock(), token -> {
                if (this.closed) {
                    return StageSupport.completedStage(false);
                }
                return this.fillMore().thenApply(Either::isRight).exceptionally(e -> true);
            })));
            return listener;
        }

        @Override
        public CompletionStage<Void> close() {
            return StageSupport.tryComposeWith(this.lock.acquireLock(), token -> {
                this.closed = true;
                List closeFutures = this.pendingResults.stream().map(f -> f.thenCompose(either -> either.fold(end -> StageSupport.voidStage(), this.closeFn))).collect(Collectors.toList());
                CompletionStage<Void> extraClose = Combinators.allOf(closeFutures);
                return StageSupport.thenComposeOrRecover(extraClose, (ig, extraCloseError) -> StageSupport.thenComposeOrRecover(AsyncIterators.convertSynchronousException(this.backingIterator::close), (ig2, backingCloseError) -> {
                    if (extraCloseError != null) {
                        return StageSupport.exceptionalStage(extraCloseError);
                    }
                    if (backingCloseError != null) {
                        return StageSupport.exceptionalStage(backingCloseError);
                    }
                    return StageSupport.voidStage();
                }));
            });
        }
    }

    private static class EmptyAsyncIterator<T>
    implements AsyncIterator<T> {
        private EmptyAsyncIterator() {
        }

        @Override
        public CompletionStage<Either<AsyncIterator.End, T>> nextStage() {
            return AsyncIterator.End.endStage();
        }

        public String toString() {
            return "EmptyAsyncIterator";
        }
    }
}

