/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.output;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public final class SecureByteArrayOutputStream
extends ByteArrayOutputStream {
    public SecureByteArrayOutputStream() {
    }

    public SecureByteArrayOutputStream(int initialSize) {
        super(initialSize);
    }

    @Override
    public void close() {
        Arrays.fill(this.buf, (byte)0);
    }

    @Override
    public void write(int b) {
        byte[] oldBuf = this.buf;
        super.write(b);
        if (this.buf != oldBuf) {
            Arrays.fill(oldBuf, (byte)0);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        byte[] oldBuf = this.buf;
        super.write(b, off, len);
        if (this.buf != oldBuf) {
            Arrays.fill(oldBuf, (byte)0);
        }
    }
}

