/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.streams.stages;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.streams.Engine;
import io.smallrye.mutiny.streams.operators.TerminalStage;
import io.smallrye.mutiny.streams.operators.TerminalStageFactory;
import io.smallrye.mutiny.streams.utils.WrappedSubscriber;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.reactivestreams.Subscriber;

public class SubscriberStageFactory
implements TerminalStageFactory<Stage.SubscriberStage> {
    @Override
    public <I, O> TerminalStage<I, O> create(Engine engine, Stage.SubscriberStage stage) {
        Subscriber subscriber = Objects.requireNonNull(stage).getRsSubscriber();
        Objects.requireNonNull(subscriber);
        return new SubscriberStage(subscriber);
    }

    private static class SubscriberStage<I>
    implements TerminalStage<I, Void> {
        private final Subscriber<I> subscriber;

        SubscriberStage(Subscriber<I> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public CompletionStage<Void> apply(Multi<I> source) {
            WrappedSubscriber<I> wrapped = new WrappedSubscriber<I>(this.subscriber);
            source.subscribe().withSubscriber(AdaptersToFlow.subscriber(wrapped));
            return wrapped.future();
        }
    }
}

