/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public class ElasticsearchDoubleFieldCodec
implements ElasticsearchFieldCodec<Double> {
    public static final ElasticsearchDoubleFieldCodec INSTANCE = new ElasticsearchDoubleFieldCodec();

    private ElasticsearchDoubleFieldCodec() {
    }

    @Override
    public JsonElement encode(Double value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Double decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.DOUBLE.fromElement(element);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return INSTANCE == other;
    }
}

