/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;
import java.util.function.Consumer;

class ExtensionPhaseRegistrationAction {
    private final Set<Class<?>> types;
    private final Consumer<ProcessBean<?>> beanAcceptor;
    private final Consumer<ProcessObserverMethod<?, ?>> observerAcceptor;

    ExtensionPhaseRegistrationAction(Set<Class<?>> types, Consumer<ProcessBean<?>> beanAcceptor, Consumer<ProcessObserverMethod<?, ?>> observerAcceptor) {
        this.types = types;
        this.beanAcceptor = beanAcceptor;
        this.observerAcceptor = observerAcceptor;
    }

    void run(ProcessBean<?> pb) {
        if (this.beanAcceptor == null) {
            return;
        }
        Set beanTypes = pb.getBean().getTypes();
        if (this.satisfies(beanTypes)) {
            this.beanAcceptor.accept(pb);
        }
    }

    void run(ProcessObserverMethod<?, ?> pom) {
        if (this.observerAcceptor == null) {
            return;
        }
        Type observedType = pom.getObserverMethod().getObservedType();
        if (this.satisfiesObserverMethod(observedType)) {
            this.observerAcceptor.accept(pom);
        }
    }

    private boolean satisfies(Set<Type> inspectedTypes) {
        for (Type type : this.types) {
            Class<?> rawType = ExtensionPhaseRegistrationAction.getRawType(type);
            if (rawType == null || !inspectedTypes.contains(rawType)) continue;
            return true;
        }
        return false;
    }

    private boolean satisfiesObserverMethod(Type observedType) {
        Class<?> rawObservedType = ExtensionPhaseRegistrationAction.getRawType(observedType);
        if (rawObservedType == null) {
            return false;
        }
        for (Type type : this.types) {
            Class<?> rawType = ExtensionPhaseRegistrationAction.getRawType(type);
            if (rawType == null || !rawType.isAssignableFrom(rawObservedType)) continue;
            return true;
        }
        return false;
    }

    private static Class<?> getRawType(Type type) {
        Class<?> rawType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            return ExtensionPhaseRegistrationAction.getRawType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return ExtensionPhaseRegistrationAction.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType && (rawType = ExtensionPhaseRegistrationAction.getRawType(((GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(rawType, 0).getClass();
        }
        return null;
    }
}

