/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.faces.ComponentSupport;
import com.sun.faces.util.FacesLogger;
import jakarta.el.MethodExpression;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ViewHandler
extends TagHandlerImpl {
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private static final Class<?>[] LISTENER_SIG = new Class[]{PhaseEvent.class};
    private final TagAttribute locale = this.getAttribute("locale");
    private final TagAttribute renderKitId = this.getAttribute("renderKitId");
    private final TagAttribute contentType = this.getAttribute("contentType");
    private final TagAttribute encoding = this.getAttribute("encoding");
    private final TagAttribute beforePhase;
    private final TagAttribute afterPhase;
    private final TagAttribute transientFlag;
    private final TagAttribute contracts;

    public ViewHandler(TagConfig config) {
        super(config);
        TagAttribute testForNull = this.getAttribute("beforePhase");
        this.beforePhase = null == testForNull ? this.getAttribute("beforePhaseListener") : testForNull;
        testForNull = this.getAttribute("afterPhase");
        this.afterPhase = null == testForNull ? this.getAttribute("afterPhaseListener") : testForNull;
        this.contracts = this.getAttribute("contracts");
        this.transientFlag = this.getAttribute("transient");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        block16: {
            UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
            if (root != null) {
                MethodExpression m;
                String v;
                if (this.renderKitId != null) {
                    v = this.renderKitId.getValue(ctx);
                    root.setRenderKitId(v);
                }
                if (this.contentType != null) {
                    v = this.contentType.getValue(ctx);
                    ctx.getFacesContext().getAttributes().put("facelets.ContentType", v);
                }
                if (this.encoding != null) {
                    v = this.encoding.getValue(ctx);
                    ctx.getFacesContext().getAttributes().put("facelets.Encoding", v);
                    root.getAttributes().put("facelets.Encoding", v);
                }
                if (this.beforePhase != null) {
                    m = this.beforePhase.getMethodExpression(ctx, null, (Class[])LISTENER_SIG);
                    root.setBeforePhaseListener(m);
                }
                if (this.afterPhase != null) {
                    m = this.afterPhase.getMethodExpression(ctx, null, (Class[])LISTENER_SIG);
                    root.setAfterPhaseListener(m);
                }
                if (this.contracts != null) {
                    String contractsValue;
                    if (ctx.getFacesContext().getAttributes().containsKey("com.sun.faces.uiCompositionCount") && LOGGER.isLoggable(Level.INFO) && ctx.getFacesContext().getApplication().getProjectStage().equals((Object)ProjectStage.Development)) {
                        LOGGER.log(Level.INFO, "f:view contracts attribute found, but not used at top level");
                    }
                    if ((contractsValue = this.contracts.getValue(ctx)) != null) {
                        List<String> contractList = Arrays.asList(contractsValue.split(","));
                        ctx.getFacesContext().setResourceLibraryContracts(contractList);
                    }
                }
                if (this.transientFlag != null) {
                    Boolean b = Boolean.valueOf(this.transientFlag.getValue(ctx));
                    root.setTransient(b.booleanValue());
                }
                String viewId = root.getViewId();
                assert (null != viewId);
                assert (0 < viewId.length());
            }
            if (this.locale != null && root != null) {
                try {
                    root.setLocale(ComponentSupport.getLocale(ctx, this.locale));
                }
                catch (TagAttributeException tae) {
                    Object result = this.locale.getObject(ctx);
                    if (null != result) break block16;
                    Locale l = Locale.getDefault();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Using {0} for locale because expression {1} returned null.", new Object[]{l, this.locale.toString()});
                    }
                    root.setLocale(l);
                }
            }
        }
        this.nextHandler.apply(ctx, parent);
    }
}

