/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.spi.core.security.UserManagement;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.ReloadableProperties;
import org.apache.activemq.artemis.utils.StringUtil;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;

public class PropertiesLoginModuleConfigurator
implements UserManagement {
    private static final String LICENSE_HEADER = "## ---------------------------------------------------------------------------\n## Licensed to the Apache Software Foundation (ASF) under one or more\n## contributor license agreements.  See the NOTICE file distributed with\n## this work for additional information regarding copyright ownership.\n## The ASF licenses this file to You under the Apache License, Version 2.0\n## (the \"License\"); you may not use this file except in compliance with\n## the License.  You may obtain a copy of the License at\n##\n## http://www.apache.org/licenses/LICENSE-2.0\n##\n## Unless required by applicable law or agreed to in writing, software\n## distributed under the License is distributed on an \"AS IS\" BASIS,\n## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n## See the License for the specific language governing permissions and\n## limitations under the License.\n## ---------------------------------------------------------------------------\n";
    private FileBasedConfigurationBuilder<PropertiesConfiguration> userBuilder;
    private FileBasedConfigurationBuilder<PropertiesConfiguration> roleBuilder;
    private PropertiesConfiguration userConfig;
    private PropertiesConfiguration roleConfig;

    public PropertiesLoginModuleConfigurator(String entryName, String brokerEtc) throws Exception {
        Configuration securityConfig;
        AppConfigurationEntry[] entries;
        if (entryName == null || entryName.length() == 0) {
            entryName = "activemq";
        }
        if ((entries = (securityConfig = Configuration.getConfiguration()).getAppConfigurationEntry(entryName)) == null || entries.length == 0) {
            throw ActiveMQMessageBundle.BUNDLE.failedToLoadSecurityConfig();
        }
        int entriesInspected = 0;
        for (AppConfigurationEntry entry : entries) {
            ++entriesInspected;
            if (!entry.getLoginModuleName().equals(PropertiesLoginModule.class.getName())) continue;
            String userFileName = (String)entry.getOptions().get("org.apache.activemq.jaas.properties.user");
            String roleFileName = (String)entry.getOptions().get("org.apache.activemq.jaas.properties.role");
            File etcDir = new File(brokerEtc);
            File userFile = new File(etcDir, userFileName);
            File roleFile = new File(etcDir, roleFileName);
            if (!userFile.exists()) {
                throw ActiveMQMessageBundle.BUNDLE.failedToLoadUserFile(brokerEtc + userFileName);
            }
            if (!roleFile.exists()) {
                throw ActiveMQMessageBundle.BUNDLE.failedToLoadRoleFile(brokerEtc + roleFileName);
            }
            Configurations configs = new Configurations();
            this.userBuilder = configs.propertiesBuilder(userFile);
            this.roleBuilder = configs.propertiesBuilder(roleFile);
            this.userConfig = (PropertiesConfiguration)this.userBuilder.getConfiguration();
            this.roleConfig = (PropertiesConfiguration)this.roleBuilder.getConfiguration();
            String roleHeader = this.roleConfig.getLayout().getHeaderComment();
            String userHeader = this.userConfig.getLayout().getHeaderComment();
            if (userHeader == null && this.userConfig.isEmpty()) {
                this.userConfig.clear();
                this.userConfig.setHeader(LICENSE_HEADER);
            }
            if (roleHeader == null && this.roleConfig.isEmpty()) {
                this.roleConfig.clear();
                this.roleConfig.setHeader(LICENSE_HEADER);
            }
            return;
        }
        if (entriesInspected == entries.length) {
            throw ActiveMQMessageBundle.BUNDLE.failedToFindLoginModuleEntry(entryName);
        }
    }

    @Override
    public void addNewUser(String username, String hash, String ... roles) {
        if (this.userConfig.getString(username) != null) {
            throw ActiveMQMessageBundle.BUNDLE.userAlreadyExists(username);
        }
        this.userConfig.addProperty(username, (Object)hash);
        this.addRoles(username, roles);
    }

    public void save() throws Exception {
        ReloadableProperties.LOCK.writeLock().lock();
        try {
            this.userBuilder.save();
            this.roleBuilder.save();
        }
        finally {
            ReloadableProperties.LOCK.writeLock().unlock();
        }
    }

    @Override
    public void removeUser(String username) {
        if (this.userConfig.getProperty(username) == null) {
            throw ActiveMQMessageBundle.BUNDLE.userDoesNotExist(username);
        }
        this.userConfig.clearProperty(username);
        this.removeRoles(username);
    }

    @Override
    public Map<String, Set<String>> listUser(String username) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (username != null && username.length() > 0) {
            result.put(username, this.findRoles(username));
        } else {
            Iterator iter = this.userConfig.getKeys();
            while (iter.hasNext()) {
                String keyUser = (String)iter.next();
                result.put(keyUser, this.findRoles(keyUser));
            }
        }
        return result;
    }

    @Override
    public void updateUser(String username, String password, String ... roles) {
        String oldPassword = (String)this.userConfig.getProperty(username);
        if (oldPassword == null) {
            throw ActiveMQMessageBundle.BUNDLE.userDoesNotExist(username);
        }
        if (password != null) {
            this.userConfig.setProperty(username, (Object)password);
        }
        if (roles != null && roles.length > 0) {
            this.removeRoles(username);
            this.addRoles(username, roles);
        }
    }

    private Set<String> findRoles(String username) {
        Iterator iter = this.roleConfig.getKeys();
        HashSet<String> roles = new HashSet<String>();
        while (iter.hasNext()) {
            String role = (String)iter.next();
            for (String roleList : this.roleConfig.getList(String.class, role)) {
                String[] items;
                for (String item : items = roleList.split(",")) {
                    if (!item.trim().equals(username)) continue;
                    roles.add(role);
                }
            }
        }
        return roles;
    }

    private void addRoles(String username, String[] roles) {
        for (String role : roles) {
            ArrayList<String> users = this.roleConfig.getList(String.class, role = role.trim());
            if (users == null) {
                users = new ArrayList<String>();
            }
            users.add(username);
            this.roleConfig.setProperty(role, (Object)StringUtil.joinStringList(users, (String)","));
        }
    }

    private void removeRoles(String username) {
        Iterator iterKeys = this.roleConfig.getKeys();
        ArrayList<Pair> updateMap = new ArrayList<Pair>();
        while (iterKeys.hasNext()) {
            String theRole = (String)iterKeys.next();
            List userList = this.roleConfig.getList(String.class, theRole);
            ArrayList<String> newList = new ArrayList<String>();
            boolean roleChaned = false;
            for (String value : userList) {
                ArrayList<String> update = new ArrayList<String>();
                String[] items = value.split(",");
                boolean found = false;
                for (String item : items) {
                    if (!item.equals(username)) {
                        update.add(item);
                        continue;
                    }
                    found = true;
                    roleChaned = true;
                }
                if (!found || update.size() <= 0) continue;
                newList.add(StringUtil.joinStringList(update, (String)","));
            }
            if (!roleChaned) continue;
            updateMap.add(new Pair((Object)theRole, newList));
        }
        for (Pair entry : updateMap) {
            this.roleConfig.clearProperty((String)entry.getA());
            if (((List)entry.getB()).size() <= 0) continue;
            this.roleConfig.addProperty((String)entry.getA(), entry.getB());
        }
    }
}

